/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.gui.ratingrules.SelectionTree;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.AbstractSearchPanel;
import ericsson.ere.gui.ratingrules.nodes.FinderResultListCellRenderer;
import ericsson.ere.gui.ratingrules.nodes.FinderResultListSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

class SimpleSearchPanel
extends AbstractSearchPanel {
    private JTextField mySimpleTextField = new JTextField();
    private JButton myFindButton;
    private SelectionTree myTree;
    private JLabel myEmptySearchResultLabel;
    private JList mySearchResultList;

    public SimpleSearchPanel(Action searchAction, SelectionTree tree) {
        this.setLayout(new GridBagLayout());
        this.myTree = tree;
        this.myFindButton = new JButton(searchAction);
        this.myEmptySearchResultLabel = new JLabel(RmaDefs.getStringResource("ratingrules.find.no.matches"));
        this.myEmptySearchResultLabel.setVisible(false);
        this.myEmptySearchResultLabel.setForeground(Color.RED);
        Insets insets = new Insets(5, 5, 0, 5);
        GridBagConstraints gbcTextField = new GridBagConstraints();
        gbcTextField.insets = insets;
        gbcTextField.fill = 2;
        gbcTextField.weightx = 1.0;
        gbcTextField.gridwidth = 2;
        gbcTextField.ipady = 4;
        GridBagConstraints gbcFindButton = new GridBagConstraints();
        gbcFindButton.anchor = 768;
        gbcFindButton.gridx = 1;
        gbcFindButton.gridy = 1;
        gbcFindButton.insets = insets;
        GridBagConstraints gbcEmptyLabel = (GridBagConstraints)gbcFindButton.clone();
        gbcEmptyLabel.anchor = 512;
        gbcEmptyLabel.gridx = 0;
        GridBagConstraints gbcResults = new GridBagConstraints();
        gbcResults.gridy = 2;
        gbcResults.gridwidth = 2;
        gbcResults.insets = new Insets(5, 5, 5, 5);
        gbcResults.fill = 1;
        gbcResults.weighty = 1.0;
        this.mySearchResultList = new JList();
        this.mySearchResultList.getSelectionModel().setSelectionMode(0);
        this.mySearchResultList.setCellRenderer(new FinderResultListCellRenderer());
        this.mySearchResultList.addListSelectionListener(new FinderResultListSelectionListener(this.myTree.getTreeComponent(), this.mySearchResultList));
        JScrollPane scrollPanel = new JScrollPane(this.mySearchResultList);
        scrollPanel.setPreferredSize(new Dimension(100, 125));
        this.add((Component)this.mySimpleTextField, gbcTextField);
        this.add((Component)this.myFindButton, gbcFindButton);
        this.add((Component)this.myEmptySearchResultLabel, gbcEmptyLabel);
        this.add((Component)scrollPanel, gbcResults);
    }

    public String getSearchText() {
        return this.mySimpleTextField.getText();
    }

    public void showEmptyResult(boolean visible) {
        this.myEmptySearchResultLabel.setVisible(visible);
    }

    public JButton getFindButton() {
        return this.myFindButton;
    }

    @Override
    public void setResultModel(ListModel model) {
        this.mySearchResultList.setModel(model);
    }
}

