/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.PaletteFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ShowFindParametersPalette
extends PaletteFrame {
    private static final int COLUMN_WIDTH_PADDING = 10;
    private Map<?, ?> myParameters;
    private JTable myJTable;

    public ShowFindParametersPalette(String nodeName, Map<?, ?> parameters) {
        super(ShowFindParametersPalette.createFrameTitle(nodeName), true, true);
        this.setLayout(new BorderLayout());
        this.setFrameIcon(RmaDefs.getImageIcon("find.png"));
        this.setPreferredSize(new Dimension(600, 300));
        this.myParameters = parameters;
        this.initComponents();
        this.pack();
    }

    private static String createFrameTitle(String s) {
        return RmaDefs.getStringResource("ratingrules.find.showFindParameter.title") + " " + s;
    }

    private void initComponents() {
        TableModel theTableModel = this.createTableModel();
        this.initGui(theTableModel);
    }

    private void initGui(TableModel model) {
        this.myJTable = this.createTable(model);
        this.add((Component)new JScrollPane(this.myJTable), "Center");
        JButton button = new JButton("Ok");
        button.setName("FindParameterPalette.JButton.CloseDialog");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowFindParametersPalette.this.dispose();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)button, "East");
        this.add((Component)panel, "South");
    }

    private JTable createTable(TableModel model) {
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.getColumnModel().getColumn(0).setHeaderValue("Parameter Name");
        table.getColumnModel().getColumn(1).setHeaderValue("Parameter Value");
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().setResizingAllowed(true);
        table.getColumnModel().getColumn(0).setCellRenderer(new TableCellLongTextRenderer());
        table.getColumnModel().getColumn(1).setCellRenderer(new TableCellLongTextRenderer());
        table.setRowSelectionAllowed(true);
        table.setAutoResizeMode(3);
        table.getInputMap().put(KeyStroke.getKeyStroke(67, 128, false), "Copy");
        table.getActionMap().put("Copy", new CopyCellAction());
        int firstColumnWidth = ShowFindParametersPalette.getFirstColumnWidth(table);
        table.getColumnModel().getColumn(0).setPreferredWidth(firstColumnWidth);
        table.getColumnModel().getColumn(0).setMaxWidth(firstColumnWidth);
        return table;
    }

    private TableModel createTableModel() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        TreeMap sortedMap = new TreeMap(this.myParameters);
        Object nameValue = sortedMap.remove("Name");
        list.add(new Object[]{"Name", nameValue});
        Object idValue = sortedMap.remove("Id");
        list.add(new Object[]{"Id", idValue});
        Object commentValue = sortedMap.remove("Comment");
        list.add(new Object[]{"Comment", commentValue});
        for (Map.Entry<?, ?> entry : sortedMap.entrySet()) {
            list.add(new Object[]{entry.getKey(), entry.getValue()});
        }
        return new DefaultTableModel((Object[][])list.toArray((T[])new Object[list.size()][2]), new Object[]{"Key", "Value"});
    }

    private static int getFirstColumnWidth(JTable table) {
        int minimumWidth = 150;
        TableModel tableModel = table.getModel();
        TableColumn firstColumn = table.getColumnModel().getColumn(0);
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        Component c = headerRenderer.getTableCellRendererComponent(table, firstColumn.getHeaderValue(), false, false, -1, 0);
        minimumWidth = c.getPreferredSize().width;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object value = table.getValueAt(i, 0);
            int editorWidth = table.getCellEditor((int)i, (int)0).getTableCellEditorComponent((JTable)table, (Object)value, (boolean)true, (int)i, (int)0).getPreferredSize().width;
            minimumWidth = Math.max(minimumWidth, editorWidth);
        }
        return minimumWidth + 10;
    }

    private static class TableCellLongTextRenderer
    extends JTextArea
    implements TableCellRenderer {
        private final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.blue.darker(), 1);

        private TableCellLongTextRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(String.valueOf(value));
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            }
            if (hasFocus && isSelected) {
                this.setBorder(this.SELECTED_BORDER);
            } else {
                this.setBorder(this.EMPTY_BORDER);
            }
            return this;
        }
    }

    private class CopyCellAction
    extends AbstractAction {
        private CopyCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String dataText = String.valueOf(ShowFindParametersPalette.this.myJTable.getValueAt(ShowFindParametersPalette.this.myJTable.getSelectedRow(), ShowFindParametersPalette.this.myJTable.getSelectedColumn()));
            StringSelection contents = new StringSelection(dataText);
            clipboard.setContents(contents, contents);
        }
    }
}

