/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.gui.ratingrules.SelectionTreeUtil;
import com.ericsson.ere.gui.undoredo.RMAUndoManager;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.swing.MouseTriggeredPopupMenu;
import com.ericsson.ere.swing.PaintControlledJTree;
import com.ericsson.ere.swing.TreeModelAdapter;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.nodes.NodeMovedEvent;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffCellRenderer;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class RatingRuleTree
extends PaintControlledJTree
implements PropertyChangeListener,
UndoableTree {
    private static final long serialVersionUID = 5543358149673804822L;
    @Deprecated
    public static final String PROP_TESTGEN_SHOW = "TestGeneration.show";
    private boolean myIsAddingNewNode = false;
    private VarTable2 myTable;
    private ClassRepository myRepository;
    private JPopupMenu myPopupMenu;
    public static final int PASTE_DEFAULT = 0;
    public static final int PASTE_AS_CHILD = 1;
    public static final int PASTE_AS_SIBLING = 2;
    public static final int PASTE_AS_CHILD_WITH_INDEX = 3;
    private boolean myShouldShowPopup = false;
    private boolean myAllowSpeedTyping;
    private boolean myOngoingUndo = false;
    private RMAUndoManager myUndoManager = new RMAUndoManager();
    private TreeChangeListener myTreeChangeListener = new TreeChangeListener();
    private SettingsMap mySettings;

    public RatingRuleTree(ClassRepository repository, SettingsMap settings) {
        this.setName("RatingRuleTree");
        this.mySettings = settings;
        this.myRepository = repository;
        this.myAllowSpeedTyping = Boolean.parseBoolean(settings.getParameterAsString("allow-speed-typing"));
        this.setCellRenderer(new TariffCellRenderer());
        this.myTable = new HelpEnabledVarTable();
        this.myTable.setName("RatingRuleTree.VarTable2.Settings");
        this.myTable.setTableModel(new VarTableModel());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setupListeners();
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setRowHeight(-1);
        GuiUtil.disableRootCollapse(this);
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.myPopupMenu = menu;
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu menu) {
        throw new UnsupportedOperationException("Use setPopupMenu instead.");
    }

    @Deprecated
    public ClassRepository getClassRepository() {
        return this.myRepository;
    }

    public JComponent getEditTable() {
        return this.myTable;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        TreePath path = this.getSelectionPath();
        this.getModel().valueForPathChanged(path, e);
    }

    @Override
    public boolean getOngoingUndo() {
        return this.myOngoingUndo;
    }

    @Override
    public TariffDAGNode getTop() {
        return (TariffDAGNode)this.getTreeModel().getRoot();
    }

    @Override
    public TariffDAGModel getTreeModel() {
        TreeModel model = this.getModel();
        if (!(model instanceof TariffDAGModel)) {
            throw new IllegalStateException("Tree model is not a TariffDAGModel");
        }
        return (TariffDAGModel)model;
    }

    @Override
    public RMAUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openANewStructure(TSTariffStructure top) {
        if (this.getModel().getRoot() == top) {
            return;
        }
        TreeChangeListener treeChangeListener = this.myTreeChangeListener;
        synchronized (treeChangeListener) {
            TariffDAGModel model;
            boolean newModel;
            this.getModel().removeTreeModelListener(this.myTreeChangeListener);
            if (this.myRepository != null) {
                this.myRepository.setTreeRootObject(top);
            }
            boolean bl = newModel = (model = top.getTreeModel()) == null;
            if (newModel) {
                model = new TariffDAGModel(this, top);
            } else {
                model.setOwnerTree(this);
            }
            model.updateSettings(this.mySettings);
            model.addTreeModelListener(this.myTreeChangeListener);
            if (newModel) {
                top.setTreeModel(model);
            }
            this.setModel(model);
            this.setSelectionPath(new TreePath(top));
        }
    }

    @Override
    public void setMenuState(TreePath path) {
    }

    @Override
    public void setOngoingUndo(boolean ongoing) {
        this.myOngoingUndo = ongoing;
    }

    private void setupListeners() {
        SelectionHandler l = new SelectionHandler();
        this.addTreeSelectionListener(l);
        this.addTreeExpansionListener(l);
        this.addMouseListener(new MouseHandler());
        if (this.myAllowSpeedTyping) {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int id = e.getKeyCode();
                    List<Variable> editedVars = RatingRuleTree.this.myTable.getTableModel().getData();
                    if (id == 113 && editedVars != null) {
                        RatingRuleTree.this.setFocusOnName(editedVars, true);
                    }
                }
            });
        }
    }

    private void setFocusOnName(List<Variable> list, boolean key) {
        Variable var = VarListUtil.getVariableForName(list, "Name");
        if (var != null) {
            Component c = var.getEditor();
            if (this.myIsAddingNewNode || key) {
                c.requestFocusInWindow();
                this.myIsAddingNewNode = false;
            }
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (this.myPopupMenu != null && (e.isPopupTrigger() || this.myShouldShowPopup)) {
            this.myShouldShowPopup = false;
            TreePath pathForLocation = this.getPathForLocation(e.getX(), e.getY());
            if (pathForLocation != null) {
                TreePath[] paths;
                boolean nodeAlreadySelected = false;
                for (TreePath path : paths = this.getSelectionPaths()) {
                    if (!path.equals(pathForLocation)) continue;
                    nodeAlreadySelected = true;
                    break;
                }
                if (!nodeAlreadySelected) {
                    this.setSelectionPath(pathForLocation);
                }
                if (this.myPopupMenu instanceof MouseTriggeredPopupMenu) {
                    ((MouseTriggeredPopupMenu)((Object)this.myPopupMenu)).show(e);
                } else {
                    this.myPopupMenu.show(this, e.getX(), e.getY());
                }
            }
        }
    }

    private class TreeChangeListener
    extends TreeModelAdapter {
        private TreeChangeListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            boolean moving = e instanceof NodeMovedEvent;
            Object[] children = e.getChildren();
            if (!moving && children != null && children.length == 1 && children[0] instanceof TSNode) {
                RatingRuleTree.this.myIsAddingNewNode = true;
            }
        }
    }

    private class HelpEnabledVarTable
    extends VarTable2 {
        private HelpEnabledVarTable() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            String clazz = RatingRuleTree.class.toString();
            if (RatingRuleTree.this.getSelectionCount() == 1) {
                TariffDAGNode node = (TariffDAGNode)RatingRuleTree.this.getSelectionPath().getLastPathComponent();
                clazz = node.getProfileClass();
            }
            GuiServiceCenter.getInstance().enableHelpKey(this, clazz, null);
            GuiServiceCenter.getInstance().enableHelpKey(RatingRuleTree.this, clazz, null);
            RatingRuleTree.this.requestFocusInWindow();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            RatingRuleTree.this.myShouldShowPopup = mouseEvent.isPopupTrigger();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (RatingRuleTree.this.getSelectionPath() == null) {
                int selRow = RatingRuleTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath selPath = RatingRuleTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (selRow != -1) {
                    TreeSelectionModel model = RatingRuleTree.this.getSelectionModel();
                    model.setSelectionPath(selPath);
                }
            }
            RatingRuleTree.this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            int mask = 192;
            if (e.getButton() == 1 && e.getClickCount() == 2 && (e.getModifiersEx() & mask) == mask && (path = RatingRuleTree.this.getPathForLocation(e.getX(), e.getY())) != null) {
                if (RatingRuleTree.this.isExpanded(path)) {
                    SelectionTreeUtil.collapseAll(RatingRuleTree.this);
                } else {
                    SelectionTreeUtil.expandAll(RatingRuleTree.this);
                }
            }
        }
    }

    class SelectionHandler
    implements TreeSelectionListener,
    TreeExpansionListener {
        SelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath oldPath = e.getOldLeadSelectionPath();
            TreePath nPath = e.getNewLeadSelectionPath();
            boolean isDelete = false;
            VarTableModel vtmodel = RatingRuleTree.this.myTable.getTableModel();
            if (oldPath != null) {
                if (nPath == null) {
                    isDelete = true;
                }
                if (vtmodel.getData().size() != 0) {
                    TariffDAGNode n = (TariffDAGNode)oldPath.getLastPathComponent();
                    n.editingFinished(vtmodel.getData(), isDelete);
                }
            }
            if (RatingRuleTree.this.getSelectionCount() > 1) {
                vtmodel.setData(Collections.emptyList());
            } else {
                TreePath newPath = RatingRuleTree.this.getSelectionPath();
                if (newPath == null) {
                    return;
                }
                TariffDAGNode node = (TariffDAGNode)newPath.getLastPathComponent();
                if (node == null) {
                    return;
                }
                List<Variable> editVariables = node.getVariablesForEditing(vtmodel);
                vtmodel.setData(editVariables);
                if (RatingRuleTree.this.myAllowSpeedTyping) {
                    RatingRuleTree.this.setFocusOnName(editVariables, false);
                }
                boolean isReadOnly = false;
                int len = newPath.getPathCount();
                for (int i = 0; i < len && !isReadOnly; ++i) {
                    TariffDAGNode n = (TariffDAGNode)newPath.getPathComponent(i);
                    if (!n.isLocked() || n.isLink() && i == len - 1) continue;
                    isReadOnly = true;
                }
                for (Variable var : editVariables) {
                    var.setEnabled(!isReadOnly);
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
        }
    }
}

