/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import ericsson.ere.gui.ratingrules.RatingRuleNodeTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.tree.TreePath;

public class RatingRuleNodeCopyAsTransferable
extends RatingRuleNodeTransferable {
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{TREE_PATH_FLAVOR, NODE_FLAVOR, LINK_TO_NODE_FLAVOR};
    private static final DataFlavor[] COPY_FLAVORS = new DataFlavor[]{TREE_PATH_FLAVOR, DataFlavor.stringFlavor};
    private DataFlavor myCopyFlavor;
    private Map<DataFlavor, Object> mySerializationCache = new WeakHashMap<DataFlavor, Object>();

    public RatingRuleNodeCopyAsTransferable(TreePath[] paths) {
        super(paths, true);
        this.myDataFlavors = FLAVORS;
    }

    public static RatingRuleNodeCopyAsTransferable createCopyTransferable(TreePath[] paths) {
        RatingRuleNodeCopyAsTransferable transferable = new RatingRuleNodeCopyAsTransferable(paths);
        transferable.setCopyFlavor(NODE_FLAVOR);
        return transferable;
    }

    public static RatingRuleNodeCopyAsTransferable createLinkTransferable(TreePath[] paths) {
        RatingRuleNodeCopyAsTransferable transferable = new RatingRuleNodeCopyAsTransferable(paths);
        transferable.setCopyFlavor(LINK_TO_NODE_FLAVOR);
        return transferable;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        Object object;
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        DataFlavor resolvedFlavor = flavor;
        if (flavor == DataFlavor.stringFlavor && this.myCopyFlavor != null) {
            resolvedFlavor = this.myCopyFlavor;
        }
        if ((object = this.mySerializationCache.get(resolvedFlavor)) == null) {
            object = super.getTransferData(resolvedFlavor);
            this.mySerializationCache.put(flavor, object);
        }
        return object;
    }

    private void setCopyFlavor(DataFlavor flavor) {
        this.myCopyFlavor = flavor;
        this.myDataFlavors = COPY_FLAVORS;
    }

    @Override
    protected String clickToString() {
        return "";
    }
}

