/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.swing.WrappingLabel;
import ericsson.ere.datatype.Time;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.management.Service;
import ericsson.ere.progress.ProgressIndicator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public final class RatingRuleFrameOpener {
    public static final String RMA_RATINGRULEFRAME_DIALOG_NAME = "RatingRuleFrameInDialog";

    private RatingRuleFrameOpener() {
    }

    public static RatingRuleFrame openFromFile(Service service, File file, boolean useSimulation, ProgressIndicator progress) throws Exception {
        return RatingRuleFrameOpener.openFromFile(service, null, file, useSimulation, progress);
    }

    public static RatingRuleFrame openFromFile(Service service, RatingPlanProxy ratingPlanProxy, File file, boolean useSimulation, ProgressIndicator progress) throws Exception {
        RatingRuleFrame.RatingPeriodDescription periodInfo = new RatingRuleFrame.RatingPeriodDescription("Period", ratingPlanProxy, new Time(Calendar.getInstance()), file.getPath());
        RatingRuleFrame rrf = RatingRuleFrame.createSafelyForFile(periodInfo, service, ratingPlanProxy, useSimulation, progress);
        return rrf;
    }

    public static void showInDialog(final Frame parent, final RatingRuleFrame rrf, final String message, final boolean resizable, final Dimension size) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                RatingRuleFrameOpener.showInDialogEDT(parent, rrf, message, resizable, size);
            }
        });
    }

    private static void showInDialogEDT(Frame parent, final RatingRuleFrame rrf, String message, boolean resizable, Dimension size) {
        String title = rrf.getTitle();
        JRootPane editor = rrf.getRootPane();
        final JDialog dialog = new JDialog((Window)parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        JPanel buttons = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setName("RatingRuleFrameInDialog_okButton");
        cancelButton.setName("RatingRuleFrameInDialog_cancelButton");
        buttons.add(okButton);
        buttons.add(cancelButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (rrf.save(null)) {
                    dialog.setVisible(false);
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (rrf.isOkToDiscardChanges()) {
                    dialog.setVisible(false);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        if (message != null) {
            WrappingLabel label = new WrappingLabel(message);
            label.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
            panel.add((Component)label, "North");
        }
        editor.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
        panel.add((Component)editor, "Center");
        panel.add((Component)buttons, "South");
        dialog.add(panel);
        dialog.setSize(size);
        dialog.setName(RMA_RATINGRULEFRAME_DIALOG_NAME);
        dialog.setLocationRelativeTo(parent);
        dialog.setResizable(resizable);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        rrf.dispose();
    }
}

