/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.dataset.jump.AbstractJumperSupport;
import com.ericsson.ere.dataset.jump.SelectionTreeDestination;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.selectiontree.NoTreeFoundException;
import ericsson.ere.management.RatingPlan;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RatingRuleFrameJumper
extends AbstractJumperSupport {
    protected RatingManagerProxy myRatingManagerProxy;
    private SelectionTreeDestination mySelf;
    private RatingPlan myRatingPlanCache = null;
    private int myRatingPlanCacheTag;

    public RatingRuleFrameJumper(RatingManagerProxy proxy, SelectionTreeDestination myself) {
        this.myRatingManagerProxy = proxy;
        this.setMyself(myself);
    }

    public void emptyRatingPlanCache() {
        this.myRatingPlanCache = null;
    }

    @Override
    public RatingPlan getRatingPlan(SelectionTreeDestination wantedRatingPlan) {
        ServiceProviderProxy serviceProviderProxy;
        int tag;
        int n = tag = this.getJumpContext() != null ? this.getJumpContext().hashCode() : 0;
        if (!(this.myRatingPlanCache != null && wantedRatingPlan.isEqualToRatingPlan(this.myRatingPlanCache) && tag == this.myRatingPlanCacheTag || (serviceProviderProxy = this.myRatingManagerProxy.getServiceProviderListProxy().getServiceProvider(wantedRatingPlan.getProviderName())) == null)) {
            RatingPlanProxy ratingPlanProxy = serviceProviderProxy.getRatingPlanProxy(wantedRatingPlan.getPlanName());
            if (ratingPlanProxy == null) {
                throw new NoTreeFoundException("Error in configuration. Rating Plan missing.");
            }
            this.myRatingPlanCache = ratingPlanProxy.getRatingPlanObject(this.getJumpContext());
            this.myRatingPlanCacheTag = tag;
        }
        return this.myRatingPlanCache;
    }

    @Override
    public List<SelectionTreeDestination> getSelectionTreeDestinationsForService(String serviceName) {
        ArrayList<SelectionTreeDestination> retList = new ArrayList<SelectionTreeDestination>();
        Vector<ServiceProviderProxy> serviceProviderList = this.myRatingManagerProxy.getServiceProviderListProxy().getServiceProviderList();
        for (ServiceProviderProxy spProxy : serviceProviderList) {
            Vector<RatingPlanProxy> ratingPlanList = spProxy.getRatingPlanList();
            for (RatingPlanProxy planProx : ratingPlanList) {
                String currentServiceName = planProx.getServiceName();
                if (!serviceName.equals(currentServiceName)) continue;
                retList.add(new SelectionTreeDestination(planProx.getName(), currentServiceName, spProxy.getName()));
            }
        }
        int index = 0;
        for (SelectionTreeDestination dest : retList) {
            if (this.mySelf.isEqual(dest)) {
                retList.remove(index);
                break;
            }
            ++index;
        }
        return retList;
    }

    @Override
    public SelectionTreeDestination getMyself() {
        return this.mySelf;
    }

    @Override
    public void setMyself(SelectionTreeDestination destination) {
        this.mySelf = destination;
    }
}

