/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeMigrator;
import com.ericsson.ere.selectiontree.structures.ChainMigrator;
import com.ericsson.ere.selectiontree.structures.DefaultMigrator;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.RatingRuleTreeNodeFactory;
import ericsson.ere.interfaces.XMLInitializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RatingJTreeNodeFactory
implements RatingRuleTreeNodeFactory {
    protected final ClassRepository myClassRepository;
    private final SelectionTreeNodeMigrator myMigrator;

    public RatingJTreeNodeFactory(String service, ClassRepository rep) {
        this.myClassRepository = rep;
        this.myMigrator = new ChainMigrator(new DefaultMigrator(), rep.getMigrator());
    }

    private boolean isLink(Node aNode) {
        Node typeAttr;
        NamedNodeMap attr = null;
        if (aNode.hasAttributes()) {
            attr = aNode.getAttributes();
        }
        return attr != null && (typeAttr = attr.getNamedItem("type")) != null && "link".equals(typeAttr.getNodeValue());
    }

    @Override
    public XMLInitializable createTariffStructure(Node config) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        this.myMigrator.migrateTariffStructure(config);
        if (this.isLink(config)) {
            return this.internalCreateLink(config);
        }
        return this.internalCreateTariffStructure(config);
    }

    @Override
    public XMLInitializable createNode(Node config) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        this.myMigrator.migrateNode(config);
        if (this.isLink(config)) {
            return this.internalCreateLink(config);
        }
        return this.internalCreateNode(config);
    }

    @Override
    public XMLInitializable createCondition(Node config) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        this.myMigrator.migrateCondition(config);
        if (this.isLink(config)) {
            return this.internalCreateLink(config);
        }
        return this.internalCreateCondition(config);
    }

    @Override
    public XMLInitializable createModifier(Node iterator) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        this.myMigrator.migrateModifier(iterator);
        if (this.isLink(iterator)) {
            return this.internalCreateLink(iterator);
        }
        return this.internalCreateModifier(iterator);
    }

    @Override
    public void connect(XMLInitializable parent, XMLInitializable child) throws Exception {
        DAGNode parentNode = (DAGNode)((Object)parent);
        DAGNode childNode = (DAGNode)((Object)child);
        parentNode.addChild(childNode);
    }

    protected XMLInitializable internalCreateLink(Node config) throws Exception {
        return new TSLink(this.myClassRepository).init(config);
    }

    protected XMLInitializable internalCreateTariffStructure(Node config) throws Exception {
        return new TSTariffStructure(this.myClassRepository).init(config);
    }

    protected XMLInitializable internalCreateNode(Node config) throws Exception {
        return new TSNode(this.myClassRepository).init(config);
    }

    protected XMLInitializable internalCreateCondition(Node config) throws Exception {
        return new TSCondition(this.myClassRepository).init(config);
    }

    protected XMLInitializable internalCreateModifier(Node config) throws Exception {
        return new TSModifier(this.myClassRepository).init(config);
    }
}

