/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log.logtable;

import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.log.LogOutput;
import ericsson.ere.gui.log.logtable.LogTableCellRenderer;
import ericsson.ere.gui.log.logtable.LogTableEntry;
import ericsson.ere.gui.log.logtable.LogTableModel;
import ericsson.ere.gui.log.logtable.LogTableModelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.logging.LogRecord;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LogTable
extends JPanel
implements LogOutput {
    private JTable myTable = null;
    private LogTableModelInterface myModel = null;
    private JPopupMenu myPopupMenu;

    public LogTable(LogTableModelInterface model) {
        super(new BorderLayout());
        this.myModel = model;
        this.init();
    }

    private void init() {
        this.enableFirstRowSelectionWhenTableChanges();
        this.myTable = new JTable(this.myModel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(Color.WHITE);
        this.myTable.setBackground(Color.WHITE);
        scrollPane.getViewport().add(this.myTable);
        this.add((Component)scrollPane, "Center");
        this.setupColumnRenderers();
        this.configureColumnWidths();
        this.myTable.setSelectionMode(0);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.enableTableKeyboardControls();
        this.enableTableAutoScrollToLastRow();
        this.enableRightClickSelectionAndPopupMenu(scrollPane);
        this.setComponentNames(scrollPane);
    }

    private void setupColumnRenderers() {
        LogTableCellRenderer renderer = new LogTableCellRenderer();
        for (int i = 0; i < this.myTable.getColumnCount(); ++i) {
            this.myTable.setDefaultRenderer(this.myTable.getColumnClass(i), renderer);
        }
    }

    private void configureColumnWidths() {
        this.myTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.myTable.getColumnModel().getColumn(3).setMaxWidth(75);
        this.myTable.getColumnModel().getColumn(1).setPreferredWidth(140);
    }

    private void setComponentNames(JScrollPane scrollPane) {
        this.myTable.setName("LogTable.JTable.Log");
        scrollPane.setName("LogTable.JScrollPane.Scroller");
    }

    private void enableFirstRowSelectionWhenTableChanges() {
        assert (this.myTable == null) : "The table must not have been created yet!";
        this.myModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    LogTable.this.setSelectedRow(0);
                }
            }
        });
    }

    private void enableRightClickSelectionAndPopupMenu(JScrollPane scrollPane) {
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopupMenu(e);
            }

            private void maybeShowPopupMenu(MouseEvent e) {
                if (e.isPopupTrigger() && LogTable.this.myPopupMenu != null) {
                    LogTable.this.setSelectedRow(LogTable.this.myTable.rowAtPoint(e.getPoint()));
                    LogTable.this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }
        };
        this.myTable.addMouseListener(listener);
        scrollPane.addMouseListener(listener);
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.myTable.getSelectionModel().addListSelectionListener(listener);
    }

    private void enableTableKeyboardControls() {
        this.myTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127 && (row = LogTable.this.getSelectedRow()) >= 0) {
                    LogTableEntry entry = LogTable.this.myModel.getEntryAt(row);
                    LogTable.this.myModel.clearLogEntry(entry);
                    LogTable.this.setSelectedRow(Math.min(row, LogTable.this.myTable.getRowCount() - 1));
                    e.consume();
                }
            }
        });
    }

    private void enableTableAutoScrollToLastRow() {
        this.myModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1 && LogTable.this.myTable.isShowing()) {
                    Rectangle rect = LogTable.this.myTable.getCellRect(e.getLastRow(), 0, true);
                    LogTable.this.myTable.scrollRectToVisible(rect);
                }
            }
        });
    }

    public int getSelectedRow() {
        return this.myTable.getSelectedRow();
    }

    public int rowAtPoint(Point p) {
        return this.myTable.rowAtPoint(p);
    }

    public LogTableEntry getSelectedEntry() {
        return this.myModel.getEntryAt(this.getSelectedRow());
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.myPopupMenu = menu;
    }

    public void setSelectedRow(int newrow) {
        if (this.myTable.getModel().getValueAt(newrow, 0) == null) {
            this.myTable.clearSelection();
        } else {
            this.myTable.setRowSelectionInterval(newrow, newrow);
        }
    }

    public void setSelectedEntry(long logEntrySequenceNr) {
        int entryColumnIndex = Arrays.asList(LogTableModel.colNames).indexOf("Entry");
        for (int row = this.myModel.getRowCount() - 1; row >= 0; --row) {
            if ((Long)this.myModel.getValueAt(row, entryColumnIndex) != logEntrySequenceNr) continue;
            this.setSelectedRow(row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, entryColumnIndex, true));
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void publish(final LogRecord someRecord) {
        EDT.runLater(new Runnable(){

            @Override
            public void run() {
                LogTable.this.myModel.add(someRecord);
            }
        });
    }
}

