/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log.logfile;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class PlainFileFormatter
extends Formatter {
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS z");

    @Override
    public String getHead(Handler h) {
        Date date = new Date(System.currentTimeMillis());
        String dateString = this.formatter.format(date);
        return new String("====== LOG STARTED " + dateString + " ======\n");
    }

    @Override
    public String format(LogRecord rec) {
        StringBuffer msg = new StringBuffer();
        Date date = new Date(rec.getMillis());
        String dateString = this.formatter.format(date);
        msg.append(dateString);
        msg.append(rec.getLevel().getName());
        msg.append(":  (");
        msg.append(rec.getSourceClassName());
        msg.append(" ");
        msg.append(rec.getSourceMethodName());
        msg.append(") ");
        msg.append(rec.getMessage());
        msg.append("\n");
        return msg.toString();
    }

    @Override
    public String getTail(Handler h) {
        Date date = new Date(System.currentTimeMillis());
        String dateString = this.formatter.format(date);
        return new String("====== LOG CLOSED " + dateString + " ======\n");
    }
}

