/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log;

import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.text.ReadOnlyDocument;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.log.LogConfig;
import ericsson.ere.gui.log.LogHandler;
import ericsson.ere.gui.log.LogPopMenu;
import ericsson.ere.gui.log.logtable.FileBackedLogTableModel;
import ericsson.ere.gui.log.logtable.LogTable;
import ericsson.ere.gui.log.logtable.LogTableEntry;
import ericsson.ere.gui.log.logtable.LogTableModelInterface;
import ericsson.ere.gui.util.UtilMenuItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Node;

public class LoggerTablePanel
extends JPanel
implements UtilMenuItem {
    public static final String LOG_WINDOW_SETTINGS_BUTTON = "LogWindow.JButton.Settings";
    private static final char[] EMPTY_TEXT = new char[0];
    private LogTable myLogTable = null;
    private JTextField mySearchField = null;
    private JTextField myLocationField = null;
    private JTextField tfEntry = new JTextField();
    private JTextField tfTime = new JTextField();
    private JTextField tfLocation = new JTextField();
    private JTextField tfLevel = new JTextField();
    private JTextField tfLoggingName = new JTextField();
    private JTextArea taMessage = new JTextArea(5, 5);
    private JScrollPane spMessage = new JScrollPane();
    private static final int MAX_ENTRIES_DEFAULT = 300;
    private LogTableModelInterface myModel;

    public LoggerTablePanel(JInternalFrame aOwnerFrame, Node aConfig) {
        this("rma", null);
    }

    public static LoggerTablePanel createSafely() throws Exception {
        File file = LogConfig.getInstance().getTemporaryLogFile();
        final FileBackedLogTableModel model = new FileBackedLogTableModel(file);
        LoggerTablePanel.configureModel(model);
        LoggerTablePanel panel = EDT.runAndWait(new Callable<LoggerTablePanel>(){

            @Override
            public LoggerTablePanel call() throws Exception {
                return new LoggerTablePanel("rma", model);
            }
        });
        return panel;
    }

    private LoggerTablePanel(String theDomain, LogTableModelInterface model) {
        super(new BorderLayout());
        this.setFocusTraversalPolicy(new MyOwnFocusTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
        this.setOrCreateModel(model);
        this.myLogTable = new LogTable(this.myModel);
        this.mySearchField = new JTextField();
        this.myLocationField = new JTextField();
        JLabel searchLabel = new JLabel("Search:");
        JLabel locationLabel = new JLabel("Location:");
        JLabel lTime = new JLabel("Time:");
        JLabel lLocation = new JLabel("Location:");
        JLabel lLevel = new JLabel("Level:");
        JLabel lLoggingName = new JLabel("Name:");
        this.tfEntry.setEditable(false);
        this.tfTime.setEditable(false);
        this.tfLocation.setEditable(false);
        this.tfLevel.setEditable(false);
        this.tfLoggingName.setEditable(false);
        this.mySearchField.setToolTipText("Limits the visible entries to those containing the text entered here.");
        this.mySearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LoggerTablePanel.this.updateTextSearch(e);
            }
        });
        this.myLocationField.setToolTipText("Limits the visible entries to those matching the entered location.");
        this.myLocationField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LoggerTablePanel.this.updateLocationSearch(e);
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setLayout(new GridBagLayout());
        toolBar.add((Component)locationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        toolBar.add((Component)this.myLocationField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
        toolBar.add((Component)searchLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        toolBar.add((Component)this.mySearchField, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
        ImageIcon prefIcon = RmaDefs.getImageIconFromPath("ericsson/ere/gui/log/Preferences16.gif");
        JButton settings = new JButton(prefIcon);
        settings.setName(LOG_WINDOW_SETTINGS_BUTTON);
        settings.setToolTipText("Log Settings");
        settings.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiServiceCenter.getInstance().settingsAction("Log Settings");
            }
        });
        toolBar.add((Component)settings, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new GridBagLayout());
        dataPanel.add((Component)lLevel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 0, 5), 0, 0));
        dataPanel.add((Component)this.tfLevel, new GridBagConstraints(3, 0, 1, 1, 0.33, 0.0, 13, 2, new Insets(12, 0, 0, 5), 0, 0));
        dataPanel.add((Component)lTime, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 0, 0, 5), 0, 0));
        dataPanel.add((Component)this.tfTime, new GridBagConstraints(5, 0, 1, 1, 0.33, 0.0, 13, 2, new Insets(12, 0, 0, 12), 0, 0));
        dataPanel.add((Component)lLocation, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 0, 5), 0, 0));
        dataPanel.add((Component)this.tfLocation, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        dataPanel.add((Component)lLoggingName, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        dataPanel.add((Component)this.tfLoggingName, new GridBagConstraints(5, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 12), 0, 0));
        this.spMessage = new JScrollPane(20, 31);
        this.taMessage.setEditable(false);
        this.taMessage.setWrapStyleWord(true);
        this.taMessage.setLineWrap(true);
        this.spMessage.getViewport().add((Component)this.taMessage, null);
        dataPanel.add((Component)this.spMessage, new GridBagConstraints(0, 2, 6, 1, 1.0, 1.0, 13, 1, new Insets(12, 12, 12, 12), 0, 0));
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)this.myLogTable, "Center");
        tablePanel.add((Component)toolBar, "North");
        tablePanel.setBackground(Color.WHITE);
        dataPanel.setMinimumSize(new Dimension(200, 200));
        JSplitPane splitPane = new JSplitPane(0, tablePanel, new JScrollPane(dataPanel));
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(200);
        splitPane.setBackground(Color.WHITE);
        splitPane.setResizeWeight(0.5);
        this.add(splitPane);
        splitPane.setDividerLocation(0.5);
        this.setBackground(Color.WHITE);
        this.setupLogMenu(theDomain);
        this.setupEntryDisplayAtRowSelection();
        this.setInitialRowSelection();
        this.setComponentNames();
        this.enableHelpKey();
    }

    private void setOrCreateModel(LogTableModelInterface model) {
        this.myModel = model;
        if (this.myModel == null) {
            this.myModel = new FileBackedLogTableModel(LogConfig.getInstance().getTemporaryLogFile());
            LoggerTablePanel.configureModel(this.myModel);
        }
    }

    private void setupLogMenu(String theDomain) {
        JPopupMenu menu = this.createPopupMenu(theDomain, LogConfig.getInstance().getHandler());
        this.myLogTable.setPopupMenu(menu);
    }

    private void enableHelpKey() {
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    private void setComponentNames() {
        this.taMessage.setName("LogPanel.JTextArea.LogMessage");
        this.mySearchField.setName("LogPanel.JTextField.SearchField");
        this.myLocationField.setName("LogPanel.JTextField.LocationField");
    }

    private void setInitialRowSelection() {
        if (this.myModel.getRowCount() > 0) {
            this.setSelectedEntry(this.myModel.getEntryAt((int)(this.myModel.getRowCount() - 1)).sequenceNumber);
        }
    }

    private void setupEntryDisplayAtRowSelection() {
        this.myLogTable.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    LoggerTablePanel.this.showCurrentRowSelection();
                }
            }
        });
    }

    private JPopupMenu createPopupMenu(String theDomain, LogHandler handler) {
        LogPopMenu popupMenu = new LogPopMenu(theDomain, handler);
        JMenuItem clear = new JMenuItem("Clear log window");
        clear.setName("LogPopupMenu.MenuItem.ClearLogWindow");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerTablePanel.this.clearForm();
            }
        });
        popupMenu.add(new JSeparator());
        popupMenu.add(clear);
        return popupMenu;
    }

    private void setMessageText(char[] chars) {
        this.taMessage.setDocument(new ReadOnlyDocument(chars));
    }

    private void clearLogInfoArea() {
        this.tfTime.setText("");
        this.tfLocation.setText("");
        this.tfLevel.setText("");
        this.tfLoggingName.setText("");
        this.setMessageText(EMPTY_TEXT);
    }

    public void clearForm() {
        this.myModel.clearAllEntries();
        this.clearLogInfoArea();
    }

    public void updateForm(boolean updateCanceled) throws IOException {
        this.myModel.refresh();
    }

    public void showCurrentRowSelection() {
        LogTableEntry tEntry;
        int currentRow = this.myLogTable.getSelectedRow();
        LogTableEntry logTableEntry = tEntry = currentRow >= 0 ? this.myLogTable.getSelectedEntry() : null;
        if (tEntry != null) {
            this.tfTime.setText(tEntry.timeString);
            this.tfLocation.setText(tEntry.source);
            this.tfLevel.setText(tEntry.levelString);
            this.tfLoggingName.setText(tEntry.getLoggerName);
            this.setMessageText(tEntry.message.toCharArray());
            this.taMessage.setCaretPosition(0);
        } else {
            this.clearLogInfoArea();
        }
    }

    private void updateTextSearch(KeyEvent e) {
        Object source = e.getSource();
        String text = ((JTextField)source).getText();
        this.myModel.limitVisibleSearch(text);
    }

    private void updateLocationSearch(KeyEvent e) {
        Object source = e.getSource();
        String text = ((JTextField)source).getText();
        this.myModel.limitVisibleLocation(text);
    }

    public void setSelectedEntry(long logEntrySequenceNr) {
        this.myLogTable.setSelectedEntry(logEntrySequenceNr);
        this.showCurrentRowSelection();
    }

    public void registerOutput(LogHandler handler) {
        handler.addOutput(this.myLogTable);
    }

    public void unregisterOutput(LogHandler handler) {
        handler.removeOutput(this.myLogTable);
    }

    private static void configureModel(LogTableModelInterface model) {
        int maxEntries;
        Properties prop = RmaDefs.getInstance().properties;
        String sMaxEntries = prop.getProperty(RmaDefs.PROP_LOG_MAX_ENTRIES, "300");
        try {
            maxEntries = Integer.parseInt(sMaxEntries);
        }
        catch (NumberFormatException nfe) {
            maxEntries = 300;
        }
        model.setMaxEntries(maxEntries);
        model.refresh();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return "Log";
    }

    @Override
    public boolean isClosable() {
        return true;
    }

    @Override
    public boolean isIconifiable() {
        return true;
    }

    @Override
    public boolean isMaximizable() {
        return true;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public void updateTableFromRmaProperties() {
        LoggerTablePanel.configureModel(this.myModel);
    }

    public class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent.equals(LoggerTablePanel.this.myLocationField)) {
                return LoggerTablePanel.this.mySearchField;
            }
            if (aComponent.equals(LoggerTablePanel.this.mySearchField)) {
                return LoggerTablePanel.this.myLogTable;
            }
            if (aComponent.equals(LoggerTablePanel.this.myLogTable)) {
                return LoggerTablePanel.this.myLocationField;
            }
            return LoggerTablePanel.this.mySearchField;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent.equals(LoggerTablePanel.this.myLocationField)) {
                return LoggerTablePanel.this.myLogTable;
            }
            if (aComponent.equals(LoggerTablePanel.this.myLogTable)) {
                return LoggerTablePanel.this.mySearchField;
            }
            if (aComponent.equals(LoggerTablePanel.this.mySearchField)) {
                return LoggerTablePanel.this.myLocationField;
            }
            return LoggerTablePanel.this.mySearchField;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return LoggerTablePanel.this.mySearchField;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return LoggerTablePanel.this.mySearchField;
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return LoggerTablePanel.this.myLogTable;
        }
    }
}

