/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.help;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.help.HelpItem;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HelpSystem {
    private static final String TAG_HELPITEMLIST = "HelpItemList";
    public static final String DEFAULT_HELPBROKERID = "RMA";
    private static final String DEFAULT_HELP_MENU_NAME = "RMA - User Guide";
    private static final String DEFAULT_HELPSETNAME = "ericsson/ere/help/rma-help.hs";
    protected static final String DEFAULT_HELPINDEXFILE = "ericsson/ere/gui/help/appToHelpId.xml";
    private static HelpSystem myHelpSystem = null;
    private Map<String, HelpItem> myHelpItems = new LinkedHashMap<String, HelpItem>();
    private Map<String, String> myBrokerLookUpTable = new HashMap<String, String>();

    protected HelpSystem() {
        try {
            this.registerHelpItem(DEFAULT_HELPBROKERID, DEFAULT_HELPSETNAME, DEFAULT_HELPINDEXFILE, DEFAULT_HELP_MENU_NAME, null);
        }
        catch (Exception e) {
            RmaDefs.loggerHelp.warning("Can not create Default-HelpItem  for RMA");
        }
        this.readConfig();
        this.createBrokerLookupTable();
    }

    private void createBrokerLookupTable() {
        this.myBrokerLookUpTable = new HashMap<String, String>();
        String[] brokers = this.getRegisteredHelpBrokerIds();
        for (int ii = 0; ii < brokers.length; ++ii) {
            HelpItem currentHelpItem = this.getHelpItem(brokers[ii]);
            if (currentHelpItem.getReferenceMap() == null) continue;
            for (String reference : currentHelpItem.getReferenceMap().keySet()) {
                if (this.myBrokerLookUpTable.get(reference) != null) {
                    RmaDefs.loggerHelp.warning("Reference " + reference + " already registered for broker " + this.myBrokerLookUpTable.get(reference) + " overwritten with broker " + brokers[ii]);
                }
                this.myBrokerLookUpTable.put(reference, brokers[ii]);
            }
        }
    }

    private void readConfig() {
        Vector<Node> config = Config.getInstance().getConfigFor(TAG_HELPITEMLIST);
        if (config != null) {
            for (int ii = 0; ii < config.size(); ++ii) {
                if (!(config.get(ii) instanceof Element)) continue;
                this.registerHelpItem((Element)config.get(ii));
            }
        }
    }

    protected void registerHelpItem(String brokerId, String helpSet, String helpIndexFile, String menuName, String defaultRef) {
        try {
            HelpItem helpItemToRegister = new HelpItem(brokerId, helpSet, helpIndexFile, menuName, defaultRef);
            this.myHelpItems.put(brokerId, helpItemToRegister);
        }
        catch (Exception e) {
            RmaDefs.loggerHelp.warning("Can not create HelpItem  for BrokerId: '" + brokerId + "'");
        }
    }

    private void registerHelpItem(Element element) {
        String brokerId = element.getAttribute("id");
        try {
            HelpItem helpItemToRegister = new HelpItem(element);
            this.myHelpItems.put(brokerId, helpItemToRegister);
        }
        catch (Exception e) {
            RmaDefs.loggerHelp.warning("Can not create HelpItem  for BrokerId: '" + brokerId + "'");
        }
    }

    public String[] getRegisteredHelpBrokerIds() {
        Object[] obj = this.myHelpItems.keySet().toArray();
        String[] str = new String[obj.length];
        for (int ii = 0; ii < obj.length; ++ii) {
            str[ii] = (String)obj[ii];
        }
        return str;
    }

    public static HelpSystem getInstance() {
        if (myHelpSystem == null) {
            myHelpSystem = new HelpSystem();
        }
        return myHelpSystem;
    }

    public HelpItem getHelpItem(String brokerId) {
        return this.myHelpItems.get(brokerId);
    }

    public void enableHelpKey(Component comp, String helpId) {
        String brokerId = this.myBrokerLookUpTable.get(helpId);
        if (this.getHelpItem(brokerId) != null) {
            this.getHelpItem(brokerId).enableHelpKey(comp, helpId);
        } else {
            RmaDefs.loggerHelp.warning("can not use help broker helpset missing for broker " + helpId);
        }
    }
}

