/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.help;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HelpItem {
    public static final String ATTR_ID = "id";
    private static final String ATTR_HELPSET = "helpset";
    private static final String ATTR_REFERENCEFILE = "referencefile";
    private static final String ATTR_MENUNAME = "menu";
    private static final String ATTR_DEFAULTREF = "defaultRef";
    private static String ATTR_APPLICATION_ID = "applicationId";
    private static String ATTR_HELP_TARGET = "onlineHelpTarget";
    private String myDefaultOnlineHelpId = "Introduction_C1";
    private String myHelpSetString;
    private String myId;
    private HelpBroker myHelpBroker = null;
    private Map<String, String> myReferenceMap = null;
    private String myMenuName;

    public HelpItem(String brokerId, String helpSet, String references, String menuName, String defaultOnlineHelpID) {
        this.init(brokerId, helpSet, references, menuName, defaultOnlineHelpID);
    }

    public HelpItem(Element helpItemElement) {
        String brokerId = helpItemElement.getAttribute(ATTR_ID);
        String helpSet = helpItemElement.getAttribute(ATTR_HELPSET);
        String helpIndexFile = helpItemElement.getAttribute(ATTR_REFERENCEFILE);
        String menuName = helpItemElement.getAttribute(ATTR_MENUNAME);
        String defaultRef = helpItemElement.getAttribute(ATTR_DEFAULTREF);
        if (helpIndexFile.length() <= 0) {
            helpIndexFile = null;
        }
        if (defaultRef.length() <= 0) {
            defaultRef = null;
        }
        this.init(brokerId, helpSet, helpIndexFile, menuName, defaultRef);
    }

    private void init(String brokerId, String helpSet, String references, String menuName, String defaultOnlineHelpID) {
        this.myId = brokerId;
        this.myHelpSetString = helpSet;
        this.myHelpBroker = HelpItem.createHelpBroker(this.myHelpSetString);
        this.myReferenceMap = HelpItem.createReferenceMap(references, this.myId);
        this.myMenuName = menuName;
        if (defaultOnlineHelpID != null) {
            this.myDefaultOnlineHelpId = defaultOnlineHelpID;
        }
    }

    public String getHelpItemId() {
        return this.myId;
    }

    public String getMenuName() {
        return this.myMenuName;
    }

    public String getHelpSetString() {
        return this.myHelpSetString;
    }

    public HelpBroker getHelpBroker() {
        if (this.myHelpBroker == null) {
            this.myHelpBroker = HelpItem.createHelpBroker(this.myHelpSetString);
        }
        return this.myHelpBroker;
    }

    public void enableHelpKey(Component comp, String myHelpId) {
        if (this.myHelpBroker != null) {
            this.myHelpBroker.enableHelpKey(comp, this.getHelpId(myHelpId), this.myHelpBroker.getHelpSet());
        } else {
            System.out.println("HelpBroker == NULL no good ...");
        }
    }

    public String getHelpId(String appId) {
        if (this.myReferenceMap == null) {
            return appId;
        }
        String retStr = this.myReferenceMap.get(appId);
        if (retStr != null) {
            return retStr;
        }
        return this.myDefaultOnlineHelpId;
    }

    public Map<String, String> getReferenceMap() {
        return this.myReferenceMap;
    }

    private static HelpBroker createHelpBroker(String helpSetString) {
        HelpSet helpSet = null;
        HelpBroker hb = null;
        ClassLoader loader = EreClassLoader.getClassLoader();
        try {
            URL url = EreClassLoader.getResource(helpSetString);
            if (url == null) {
                throw new Exception();
            }
            helpSet = new HelpSet(loader, url);
            hb = helpSet.createHelpBroker();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hb;
    }

    private static Map<String, String> createReferenceMap(String references, String brokerId) {
        boolean defaultBroker = brokerId.equals("RMA");
        HashMap<String, String> theReferenceMap = new HashMap<String, String>();
        URL url = null;
        if (references == null) {
            return null;
        }
        url = EreClassLoader.getResource(references);
        if (url == null) {
            return null;
        }
        try {
            StringBuffer loaded = new StringBuffer();
            InputStream in = url.openStream();
            loaded = HelpItem.StringBufferFromInputStream(in);
            Document document = XMLUtil.buildDocumentFromString(loaded.toString());
            Element root = document.getDocumentElement();
            theReferenceMap = new HashMap();
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element currentElement;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || ((currentElement = (Element)node).hasAttribute("brokerId") || !defaultBroker) && (!currentElement.hasAttribute("brokerId") || defaultBroker || !currentElement.getAttribute("brokerId").equals(brokerId))) continue;
                NamedNodeMap attrMap = node.getAttributes();
                String appId = attrMap.getNamedItem(ATTR_APPLICATION_ID).getNodeValue();
                String targetId = attrMap.getNamedItem(ATTR_HELP_TARGET).getNodeValue();
                Logger log = Logger.getLogger("ere.gui");
                if (log.isLoggable(Level.FINER)) {
                    log.finer("adding " + appId + "   " + targetId);
                }
                theReferenceMap.put(appId, targetId);
            }
        }
        catch (IOException ioe) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return theReferenceMap;
    }

    static StringBuffer StringBufferFromInputStream(InputStream input) throws IOException {
        char[] buf = new char[2048];
        StringBuffer loaded = new StringBuffer();
        InputStreamReader stream = new InputStreamReader(input);
        int len = stream.read(buf, 0, 2048);
        while (len >= 0) {
            loaded.append(buf, 0, len);
            len = stream.read(buf, 0, 2048);
        }
        input.close();
        if (input != null) {
            input.close();
        }
        return loaded;
    }

    static void referenceFileConsistencyCheck() {
    }
}

