/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.ProgressVisualizer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class SplashScreen
extends JWindow
implements ProgressVisualizer {
    JProgressBar progress;
    JLabel message;
    int maxProgress;
    int currentProgress;
    private JPanel bottom;
    private JLabel metaphor;
    private JLabel logo;
    private JLabel appLabel;
    private JLabel versionLabel;
    private JLabel licensedToLabel;
    private JLabel license1;
    private JLabel license2;
    private JLabel licenseNumber;
    private JPanel stretchPanel;
    private JLabel copyRightLabel;

    public SplashScreen(int maxSteps) {
        super(new JFrame("Splash"));
        this.maxProgress = maxSteps;
        this.metaphor = new JLabel();
        try {
            this.metaphor = new JLabel(this.getImageIcon(RmaDefs.getStringResource("splash.metaphor")));
            this.logo = new JLabel(this.getImageIcon(RmaDefs.getStringResource("splash.logo")));
            this.logo.setOpaque(false);
            this.logo.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.appLabel = new JLabel(RmaDefs.getStringResource("app.name"));
        this.appLabel.setFont(new Font("Arial", 0, 30));
        this.appLabel.setForeground(new Color(102, 102, 102));
        String version = RmaDefs.getStringResource("app.version");
        this.versionLabel = new JLabel(RmaDefs.getStringResource("about.version.label") + " " + version);
        this.versionLabel.setFont(new Font("Arial", 0, 11));
        this.versionLabel.setForeground(new Color(102, 102, 102));
        this.licensedToLabel = new JLabel(RmaDefs.getStringResource("app.licensed.label"));
        this.licensedToLabel.setFont(new Font("Arial", 0, 9));
        this.licensedToLabel.setForeground(new Color(0, 0, 0));
        this.license1 = new JLabel(RmaDefs.getStringResource("app.licensed.to1"));
        this.license1.setFont(new Font("Arial", 0, 9));
        this.license1.setForeground(new Color(0, 0, 0));
        this.license2 = new JLabel(RmaDefs.getStringResource("app.licensed.to2"));
        this.license2.setFont(new Font("Arial", 0, 9));
        this.license2.setForeground(new Color(0, 0, 0));
        this.licenseNumber = new JLabel(RmaDefs.getStringResource("app.license.number"));
        this.licenseNumber.setFont(new Font("Arial", 0, 9));
        this.licenseNumber.setForeground(new Color(0, 0, 0));
        this.progress = new JProgressBar(this.currentProgress, this.maxProgress);
        this.progress.setBorderPainted(false);
        this.progress.setForeground(new Color(51, 102, 153));
        if (RmaDefs.getStringResource("splash.indeterminate").toLowerCase().equals("yes")) {
            this.progress.setIndeterminate(true);
        } else {
            this.progress.setStringPainted(true);
        }
        JPanel progressPanel = new JPanel();
        progressPanel.setBackground(Color.white);
        progressPanel.setLayout(new BoxLayout(progressPanel, 0));
        progressPanel.add(Box.createHorizontalStrut(11));
        progressPanel.add(this.progress);
        progressPanel.add(Box.createHorizontalStrut(11));
        progressPanel.setBorder(new DottedBorder());
        this.stretchPanel = new JPanel();
        this.stretchPanel.setBackground(Color.white);
        this.message = new JLabel();
        this.message.setFont(new Font("Arial", 0, 9));
        this.message.setForeground(new Color(102, 102, 102));
        this.copyRightLabel = new JLabel(RmaDefs.getStringResource("app.copyright.label"));
        this.copyRightLabel.setFont(new Font("Arial", 0, 7));
        this.copyRightLabel.setForeground(new Color(102, 102, 102));
        this.bottom = new JPanel(new GridBagLayout());
        this.bottom.setBorder(new BevelBorder(0, new Color(128, 128, 128), new Color(0, 0, 0)));
        this.bottom.setBackground(Color.white);
        this.bottom.add((Component)this.metaphor, new GridBagConstraints(0, 0, 1, 12, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.bottom.add((Component)this.logo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(7, 7, 0, 0), 0, 0));
        this.bottom.add((Component)this.appLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 11, 0, 5), 0, 0));
        this.bottom.add((Component)this.versionLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 14, 5, 0), 0, 0));
        this.bottom.add((Component)this.licensedToLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 14, 0, 0), 0, 0));
        this.bottom.add((Component)this.license1, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 28, 0, 0), 0, 0));
        this.bottom.add((Component)this.license2, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 28, 0, 0), 0, 0));
        this.bottom.add((Component)this.licenseNumber, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 28, 0, 0), 0, 0));
        this.bottom.add((Component)this.stretchPanel, new GridBagConstraints(1, 8, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 11, 0, 0), 0, 0));
        this.bottom.add((Component)progressPanel, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.bottom.add((Component)this.message, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 11, 0, 11), 0, 0));
        this.bottom.add((Component)this.copyRightLabel, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 14, 11, 0), 0, 0));
        this.getContentPane().add(this.bottom);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.setVisible(true);
    }

    private ImageIcon getImageIcon(String iconName) {
        URL iconURL = this.getClass().getClassLoader().getResource("images/" + iconName);
        if (iconURL != null) {
            return new ImageIcon(iconURL, "a beautiful yet meaningless icon");
        }
        return null;
    }

    public void dismiss() {
        this.dispose();
    }

    public ProgressIndicator[] getProgressIndicator(int slices) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(this.maxProgress, this);
        return handler.splitProgress(slices);
    }

    public ProgressIndicator[] getProgressIndicator(int[] slices) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(this.maxProgress, this);
        return handler.splitProgress(slices);
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setConfirmBeforeExit() {
    }

    @Override
    public void setInfoText(String text) {
        if (text != null) {
            this.message.setText(text);
        }
    }

    @Override
    public void setProgressGoal(int goal) {
        this.progress.setMinimum(0);
        this.progress.setMaximum(goal);
    }

    @Override
    public void setValue(int value) {
        this.progress.setValue(value);
    }

    @Override
    public void showAdditionalInfo(String text) {
    }

    class DottedBorder
    extends AbstractBorder {
        int thickness = 1;
        boolean roundedCorners = false;
        Color lineColor1 = new Color(172, 175, 172);
        Color lineColor2 = new Color(245, 245, 245);
        Color lineColor3 = Color.white;

        DottedBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int i;
            BasicStroke dashedStroke1 = new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{1.0f, 3.0f, 1.0f, 3.0f}, 0.0f);
            BasicStroke dashedStroke2 = new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{1.0f, 3.0f, 1.0f, 3.0f}, 1.0f);
            BasicStroke dashedStroke3 = new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{1.0f, 3.0f, 1.0f, 3.0f}, 2.0f);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(dashedStroke1);
            g2d.setColor(this.lineColor1);
            for (i = 0; i < this.thickness; ++i) {
                if (!this.roundedCorners) {
                    g2d.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                    continue;
                }
                g2d.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, this.thickness, this.thickness);
            }
            g2d.setStroke(dashedStroke2);
            g2d.setColor(this.lineColor2);
            for (i = 0; i < this.thickness; ++i) {
                if (!this.roundedCorners) {
                    g2d.drawRect(x + i, y + i, width - i - i - 1, height - i - i - 1);
                    continue;
                }
                g2d.drawRoundRect(x + i, y + i, width - i - i - 1, height - i - i - 1, this.thickness, this.thickness);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = insets.bottom = this.thickness;
            insets.top = insets.bottom;
            insets.left = insets.bottom;
            return insets;
        }
    }
}

