/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.AbstractRmaPlugin;
import com.ericsson.ere.gui.RmaArguments;
import com.ericsson.ere.gui.appaction.ApplicationAction;
import com.ericsson.ere.gui.appaction.ApplicationActionStateController;
import com.ericsson.ere.gui.appaction.ApplicationActionStateHandler;
import com.ericsson.ere.gui.diff.DiffToolPanel;
import com.ericsson.ere.gui.editors.settingseditor.SettingsEditorPanel;
import com.ericsson.ere.gui.navigator.NavigatorConfigLoader;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.model.NavigatorTreeModel;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.EreNode;
import com.ericsson.ere.gui.navigator.nodes.InternalEreNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNode;
import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.io.IOUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.defs.RmaDefsPropertiesChangeEvent;
import ericsson.ere.defs.RmaDefsPropertiesChangeListener;
import ericsson.ere.gui.AdditionalToolBarItem;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.MenuBuilder;
import ericsson.ere.gui.RmaFrameInterface;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.help.HelpSystem;
import ericsson.ere.gui.log.LogConfig;
import ericsson.ere.gui.log.LoggerTablePanel;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.FileFilterImpl;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.gui.util.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GuiServiceCenter {
    private static final int FRAME_DISTANCE = 50;
    private static GuiServiceCenter INSTANCE = null;
    @Deprecated
    public JFrame mainWindow;
    @Deprecated
    public JPanel contentPane;
    @Deprecated
    public JDesktopPane desk;
    @Deprecated
    public JSplitPane splitPane = new JSplitPane();
    public JMenuBar menuBar;
    public final SaveMenuAction saveMenuAction;
    public final ExportMenuAction saveAsMenuAction;
    public final ImportMenuAction importMenuAction;
    public final LogToolAction logToolAction;
    public final DiffToolAction diffToolAction;
    public final SettingsAction settingsAction;
    public final ExitAction exitAction;
    public final NavigatorWindowAction navigatorWindowAction;
    public final NavigatorToolAction navigatorToolAction;
    String currentDirectory = "";
    private JInternalFrame myLoggingFrame;
    JInternalFrame mySettingsFrame;
    private Map<String, Element> myUtilities;
    public static PrintStream stdOut = System.out;
    public static PrintStream stdErr = System.err;
    private NavigatorTree myNavigatorTree = null;
    private DefaultMutableTreeNode myNavigatorRootNode = null;
    private final NavigatorTreeModel myNavigatorTreeModel;
    private JComponent myNavigatorPane = null;
    private boolean modifiedFlagForNodeConfiguration = false;
    private JFileChooser myFileChooser = null;
    private JFileChooser mySimFileChooser = null;
    public Executor myExecutor = Executors.newCachedThreadPool();
    private JToolBar myToolbar;
    private MenuBuilder myMenuBuilder = new MenuBuilder();
    private JWindow mySplashScreen = null;

    private GuiServiceCenter() {
        this.saveMenuAction = new SaveMenuAction();
        this.saveAsMenuAction = new ExportMenuAction();
        this.importMenuAction = new ImportMenuAction();
        this.logToolAction = new LogToolAction();
        this.diffToolAction = new DiffToolAction();
        this.navigatorWindowAction = new NavigatorWindowAction();
        this.navigatorToolAction = new NavigatorToolAction();
        this.settingsAction = new SettingsAction();
        this.exitAction = new ExitAction();
        this.myNavigatorTreeModel = new NavigatorTreeModel();
        RmaDefs rmaDefs = RmaDefs.getInstance();
        rmaDefs.addRmaDefsPropertiesChangeListener(this.myNavigatorTreeModel);
        rmaDefs.addRmaDefsPropertiesChangeListener(new LogSettingsChangeListener());
    }

    public synchronized JFileChooser getFileChooser() {
        if (this.myFileChooser == null) {
            this.myFileChooser = new JFileChooser();
            this.myFileChooser.addChoosableFileFilter(new FileFilterImpl("xml", "XML Files"));
            this.myFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            this.myFileChooser.setDialogTitle(null);
        }
        return this.myFileChooser;
    }

    public synchronized JFileChooser getSimFileChooser() {
        if (this.mySimFileChooser == null) {
            this.mySimFileChooser = new JFileChooser();
            this.mySimFileChooser.addChoosableFileFilter(new FileFilterImpl("xml", "XML Files"));
            this.mySimFileChooser.addChoosableFileFilter(new FileFilterImpl("txt", "Text Files"));
            this.mySimFileChooser.addChoosableFileFilter(new FileFilterImpl("sim", "Simulation Files"));
            this.mySimFileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            this.mySimFileChooser.setDialogTitle(null);
        }
        return this.mySimFileChooser;
    }

    public synchronized void setFileFilter(String filterDescription) {
        File selected = this.getFileChooser().getSelectedFile();
        FileFilter[] filter = this.getFileChooser().getChoosableFileFilters();
        for (int i = 0; i < filter.length; ++i) {
            if (filter[i].getDescription().indexOf(filterDescription) < 0) continue;
            this.getFileChooser().setFileFilter(filter[i]);
            this.getFileChooser().setSelectedFile(selected);
            return;
        }
    }

    public boolean setWindowPosition(Component frame) {
        Properties properties = RmaDefs.getInstance().properties;
        String className = frame.getClass().toString();
        int pos = className.lastIndexOf(46);
        if (pos >= 0) {
            className = className.substring(pos + 1);
        }
        if (frame instanceof RmaFrameSupport && frame instanceof JInternalFrame) {
            className = ((JInternalFrame)frame).getTitle();
        }
        className = "WorkArea." + className;
        try {
            int x = Integer.parseInt(properties.getProperty(className + ".x"));
            int y = Integer.parseInt(properties.getProperty(className + ".y"));
            int w = Integer.parseInt(properties.getProperty(className + ".width"));
            int h = Integer.parseInt(properties.getProperty(className + ".height"));
            frame.setLocation(x, y);
            frame.setSize(w, h);
        }
        catch (Exception e) {
            boolean tryNewPosition = true;
            Point newWindowPosition = new Point(0, 0);
            block2: while (tryNewPosition) {
                tryNewPosition = false;
                for (JInternalFrame otherFrame : this.desk.getAllFrames()) {
                    if (frame == otherFrame || Math.abs(newWindowPosition.x - otherFrame.getLocation().x) >= 50 || Math.abs(newWindowPosition.y - otherFrame.getLocation().y) >= 50) continue;
                    newWindowPosition = new Point(otherFrame.getLocation().x + 50, otherFrame.getLocation().y + 50);
                    tryNewPosition = true;
                    continue block2;
                }
            }
            frame.setLocation(newWindowPosition);
            return false;
        }
        return true;
    }

    public JTree getNavigatorTree() {
        return this.myNavigatorTree;
    }

    public NavigatorTreeModel getNavigatorTreeModel() {
        return this.myNavigatorTreeModel;
    }

    public void setNavigatorTree(NavigatorTree tree) {
        this.myNavigatorTree = tree;
    }

    public DefaultMutableTreeNode getNavigatorRootNode() {
        return this.myNavigatorRootNode;
    }

    public void setNavigatorRootNode(DefaultMutableTreeNode rootNode) {
        this.myNavigatorRootNode = rootNode;
        if (this.myNavigatorTree != null) {
            this.myNavigatorTree.getModel().valueForPathChanged(new TreePath(this.myNavigatorTree.getModel().getRoot()), this.myNavigatorRootNode);
        }
    }

    public Map<String, Element> getConfiguredUtilities() {
        Vector<Node> utils = Config.getInstance().getConfigFor("UtilityList");
        if (this.myUtilities == null || this.myUtilities.size() != utils.size()) {
            this.myUtilities = new Hashtable<String, Element>();
            utils = Config.getInstance().getConfigFor("UtilityList");
            for (int i = 0; utils != null && i < utils.size(); ++i) {
                Element node = (Element)utils.get(i);
                if (!node.getNodeName().equals("Utility")) continue;
                String name = node.getAttribute("Name");
                String service = node.getAttribute("Service");
                if (service != null && service.length() > 0) {
                    name = service + "." + name;
                }
                this.myUtilities.put(name, node);
            }
        }
        return this.myUtilities;
    }

    public void setNodeConfigModified(boolean modified) {
        this.modifiedFlagForNodeConfiguration = modified;
    }

    public boolean isNodeConfigModified() {
        return this.modifiedFlagForNodeConfiguration;
    }

    @Deprecated
    public void init() {
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public static synchronized void newInstance() {
        if (INSTANCE != null) {
            RmaDefs.getInstance().removeRmaDefsPropertiesChangeListener(INSTANCE.getNavigatorTreeModel());
        }
        INSTANCE = new GuiServiceCenter();
        LogConfig.getInstance().configureLogging();
    }

    public static synchronized GuiServiceCenter getInstance() {
        if (INSTANCE == null) {
            GuiServiceCenter.newInstance();
        }
        return INSTANCE;
    }

    public String getProperty(String key) {
        return RmaDefs.getInstance().properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return RmaDefs.getInstance().properties.getProperty(key, defaultValue);
    }

    @Deprecated
    public void setContentPane(JPanel contentPane) {
        this.contentPane = contentPane;
    }

    public JPanel getContentPane() {
        return (JPanel)this.mainWindow.getContentPane();
    }

    public void setDesktopPane(JDesktopPane desk) {
        this.desk = desk;
        this.setDesktopBackground();
    }

    public JDesktopPane getDesktopPane() {
        return this.desk;
    }

    private void setDesktopBackground() {
        this.desk.setBackground(Color.WHITE);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void setMainWindow(JFrame window) {
        this.mainWindow = window;
    }

    public JFrame getMainWindow() {
        return this.mainWindow;
    }

    public JMenuBar createMenuBar() {
        this.menuBar = this.myMenuBuilder.build(this);
        return this.menuBar;
    }

    public JToolBar createToolBar() {
        this.myToolbar = new JToolBar("RmaToolbar");
        this.myToolbar.add(this.navigatorToolAction).setName("NavigatorToolbarButton");
        this.myToolbar.addSeparator();
        this.myToolbar.add(this.saveMenuAction).setName("SaveMenuButton");
        this.myToolbar.add(this.importMenuAction).setName("ImportMenuButton");
        this.myToolbar.add(this.saveAsMenuAction).setName("SaveAsMenuButton");
        this.myToolbar.addSeparator();
        this.myToolbar.add(this.diffToolAction).setName("DiffToolMenuButton");
        this.myToolbar.add(this.logToolAction).setName("LogToolMenuButton");
        this.myToolbar.setRollover(true);
        return this.myToolbar;
    }

    private void save() {
        JInternalFrame frame = this.desk.getSelectedFrame();
        if (!(frame instanceof RmaFrameInterface)) {
            return;
        }
        String progressTitle = "Saving " + ((RmaFrameInterface)((Object)frame)).getContentDescription();
        final ProgressDialog progressDialog = new ProgressDialog("RMA", progressTitle);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                JInternalFrame frame = GuiServiceCenter.this.desk.getSelectedFrame();
                if (frame instanceof RmaFrameInterface) {
                    ((RmaFrameInterface)((Object)frame)).save(progressDialog.getProgressIndicator());
                }
                return new Object();
            }

            @Override
            public void finished() {
                StatusPanel.getInstance().setStatusMsg("");
                progressDialog.dispose();
            }
        };
        worker.start();
        progressDialog.setVisible(true);
    }

    private void exportFile() {
        DefaultMutableTreeNode node = this.myNavigatorTree.getSelectedNode();
        if (node instanceof AbstractNavigatorNode) {
            AbstractEreProxy proxy = ((AbstractNavigatorNode)node).getProxy();
            if (proxy != null && proxy.getAbortRefresh()) {
                DialogFactory.getErrorDialog("Not a valid node.", "Can't export from an interrupted node. Please select a valid import target node and try again.");
                return;
            }
            if (this.myNavigatorTree.getSelectedNode() == null || this.myNavigatorTree.getSelectedNode() instanceof NavigatorNode || this.myNavigatorTree.getSelectedNode() instanceof EreNode || this.myNavigatorTree.getSelectedNode() instanceof InternalEreNode) {
                DialogFactory.getErrorDialog("Not a valid source node.", "No valid export source node selected. Please select a valid export source node and try again.");
                return;
            }
            WizardView view = WizardFactory.createNavigatorExportWizard(GuiServiceCenter.getInstance().getMainWindow(), (AbstractNavigatorNode)node);
            view.run();
        }
    }

    private void importFile() {
        DefaultMutableTreeNode node = this.myNavigatorTree.getSelectedNode();
        String errorMsg = null;
        if (node == null || node instanceof NavigatorNode || node instanceof EreNode || node instanceof InternalEreNode) {
            errorMsg = "No valid import target node selected. Please select a valid import target node and try again.";
        } else {
            AbstractEreProxy proxy = ((AbstractNavigatorNode)node).getProxy();
            if (node instanceof AbstractNavigatorNode && proxy != null && proxy.getAbortRefresh()) {
                errorMsg = "Can't import to an interrupted node. Please select a valid import target node and try again.";
            } else {
                FunctionContext ctx = FunctionContext.build().withProxy(proxy).get();
                FunctionState testImpState = FunctionManagerImpl.getInstance().getStateForFunction(FunctionToken.IMPORT_ALLOWED, ctx);
                if (testImpState.getState() == FunctionState.State.OFF) {
                    this.setMsg("Import not allowed...");
                } else {
                    WizardView view = WizardFactory.createNavigatorImportWizard(GuiServiceCenter.getInstance().getMainWindow(), (AbstractNavigatorNode)node);
                    view.run();
                }
            }
        }
        if (errorMsg != null) {
            DialogFactory.getErrorDialog("Not a valid node.", errorMsg);
        }
    }

    private void setMsg(final String msg) {
        EDT.runLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.getInstance().setStatusMsg(msg);
            }
        });
    }

    public void logAction() {
        if (!this.tryActivateFrame(this.myLoggingFrame)) {
            final ProgressDialog openLogDialog = new ProgressDialog("Open Log", "Reading Log Entries...");
            openLogDialog.setIndeterminate(true);
            openLogDialog.setStringPainted(false);
            final OpenLogTask openLogWindowTask = new OpenLogTask(openLogDialog);
            openLogDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    openLogWindowTask.cancel(false);
                    openLogDialog.dispose();
                }
            });
            openLogWindowTask.execute();
            openLogDialog.setVisible(true);
        }
    }

    public static void setSelectedNoVeto(JInternalFrame frame, boolean selected) {
        GuiUtil.setSelectedIgnoringException(frame, selected);
    }

    public static void setIconNoVeto(JInternalFrame frame, boolean icon) {
        GuiUtil.setIconIgnoringException(frame, icon);
    }

    private boolean tryActivateFrame(JInternalFrame frameToActivate) {
        boolean result = false;
        if (frameToActivate != null && frameToActivate.getDesktopPane() == this.desk) {
            for (JInternalFrame frame : this.desk.getAllFrames()) {
                if (frame != frameToActivate) continue;
                if (frame.isIcon()) {
                    GuiServiceCenter.setIconNoVeto(frame, false);
                }
                GuiServiceCenter.setSelectedNoVeto(frame, true);
                result = true;
                break;
            }
            if (!result) {
                frameToActivate.setVisible(true);
                this.desk.add((Component)frameToActivate, "Center");
                GuiServiceCenter.setSelectedNoVeto(frameToActivate, true);
                result = true;
            }
        }
        return result;
    }

    public void settingsAction() {
        this.invokeSettingsFrame("");
    }

    public void settingsAction(String activeViewInRmaSettings) {
        this.invokeSettingsFrame(activeViewInRmaSettings);
    }

    private void invokeSettingsFrame(final String activeViewInRmaSettings) {
        if (!this.tryActivateFrame(this.mySettingsFrame)) {
            EDT.runLater(new Runnable(){

                @Override
                public void run() {
                    GuiServiceCenter.this.mySettingsFrame = new RmaFrameSupport("RMA Settings");
                    GuiServiceCenter.this.mySettingsFrame.getContentPane().add(new SettingsEditorPanel(GuiServiceCenter.this.mySettingsFrame, activeViewInRmaSettings));
                    if (!GuiServiceCenter.this.setWindowPosition(GuiServiceCenter.this.mySettingsFrame)) {
                        GuiServiceCenter.this.mySettingsFrame.setSize(new Dimension(600, 500));
                    }
                    GuiServiceCenter.this.mySettingsFrame.setVisible(true);
                    GuiServiceCenter.this.desk.add((Component)GuiServiceCenter.this.mySettingsFrame, "Center");
                    GuiServiceCenter.setSelectedNoVeto(GuiServiceCenter.this.mySettingsFrame, true);
                    StatusPanel.getInstance().setStatusMsg("");
                }
            });
        }
    }

    public void showLogWithSelectedEntry(long logEntrySequenceNr) {
        this.logAction();
        this.getLoggerTablePanel().setSelectedEntry(logEntrySequenceNr);
    }

    @Deprecated
    public LoggerTablePanel getLoggerPanel() {
        return this.getLoggerTablePanel();
    }

    private LoggerTablePanel getLoggerTablePanel() {
        return (LoggerTablePanel)this.myLoggingFrame.getContentPane().getComponent(0);
    }

    private void diffToolAction() {
        EDT.runLater(new Runnable(){

            @Override
            public void run() {
                RmaFrameSupport diffToolFrame = new RmaFrameSupport("Selection Tree Difference Detection Tool");
                DiffToolPanel diffToolPanel = new DiffToolPanel(diffToolFrame, null);
                diffToolFrame.getContentPane().add(diffToolPanel);
                diffToolFrame.setFrameIcon(RmaDefs.getImageIcon("components16.png"));
                if (!GuiServiceCenter.this.setWindowPosition(diffToolFrame)) {
                    diffToolFrame.setSize(new Dimension(700, 650));
                }
                diffToolFrame.setVisible(true);
                diffToolFrame.setDefaultCloseOperation(2);
                GuiServiceCenter.this.desk.add((Component)diffToolFrame, "Center");
                GuiServiceCenter.setSelectedNoVeto(diffToolFrame, true);
                StatusPanel.getInstance().setStatusMsg("");
            }
        });
    }

    boolean prepareForExit() {
        this.saveNavigatorDivider();
        RmaDefs.getInstance().saveRmaConfig();
        JInternalFrame[] frameList = this.getDesktopPane().getAllFrames();
        for (int i = 0; i < frameList.length; ++i) {
            if (!(frameList[i] instanceof RmaFrameSupport)) continue;
            if (!((RmaFrameSupport)frameList[i]).isOkToDiscardChanges()) {
                return false;
            }
            ((RmaFrameSupport)frameList[i]).dispose();
        }
        if (this.isNodeConfigModified() && DialogFactory.getQuestionDialogCustomButtons(this.mainWindow, "Node configuration", "Save node configuration before exiting?", "Yes", "No")) {
            NavigatorConfigLoader.getInstance().saveNodeConfiguration(this.getNavigatorRootNode());
        }
        return true;
    }

    public void showOrHideNavigator() {
        boolean visible;
        if (this.myNavigatorPane == null) {
            NavigatorTree navigatorTree = new NavigatorTree(this.getNavigatorTreeModel());
            this.setNavigatorTree(navigatorTree);
            this.myNavigatorPane = new JScrollPane(navigatorTree);
            this.splitPane.setLeftComponent(this.myNavigatorPane);
            this.splitPane.setRightComponent(this.desk);
            this.getContentPane().add((Component)this.splitPane, "Center");
        }
        String propVisibleName = "WorkArea." + RmaDefs.PROP_NAVIGATOR + ".Visible";
        String propDividerName = "WorkArea." + RmaDefs.PROP_NAVIGATOR + ".Divider";
        String propVisible = RmaDefs.getInstance().properties.getProperty(propVisibleName);
        if (propVisible == null) {
            RmaDefs.getInstance().properties.setProperty(propVisibleName, "true");
            propVisible = "true";
        }
        if (visible = Boolean.valueOf(propVisible).booleanValue()) {
            int divider = -1;
            try {
                divider = Integer.parseInt(RmaDefs.getInstance().properties.getProperty(propDividerName));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.splitPane.setDividerSize(4);
            this.splitPane.setDividerLocation(divider);
        } else {
            int divider = this.splitPane.getDividerLocation();
            RmaDefs.getInstance().properties.setProperty(propDividerName, Integer.toString(divider));
            this.splitPane.setDividerSize(0);
            this.splitPane.setDividerLocation(0);
        }
    }

    private void startNavigatorWindow() {
        String tag = "WorkArea." + RmaDefs.PROP_NAVIGATOR + ".Visible";
        boolean visible = Boolean.valueOf(RmaDefs.getInstance().properties.getProperty(tag)) == false;
        RmaDefs.getInstance().properties.setProperty(tag, Boolean.toString(visible));
        this.showOrHideNavigator();
    }

    public void saveNavigatorDivider() {
        String tag = "WorkArea." + RmaDefs.PROP_NAVIGATOR + ".Visible";
        boolean visible = Boolean.valueOf(RmaDefs.getInstance().properties.getProperty(tag));
        if (visible) {
            int divider = this.splitPane.getDividerLocation();
            RmaDefs.getInstance().properties.setProperty("WorkArea." + RmaDefs.PROP_NAVIGATOR + ".Divider", Integer.toString(divider));
        }
    }

    public void enableHelpKey(Component comp, String myHelpId, HelpSet hs) {
        HelpSystem.getInstance().enableHelpKey(comp, myHelpId);
    }

    public JToolBar getToolBar() {
        return this.myToolbar;
    }

    public void createAdditionalToolbarItems(String[] classNames) {
        this.myToolbar.addSeparator();
        for (int i = 0; i <= classNames.length - 1; ++i) {
            try {
                Object a;
                if (classNames[i] == null || !((a = EreClassLoader.createInstance(classNames[i])) instanceof AdditionalToolBarItem)) continue;
                ((AdditionalToolBarItem)a).setDesktopFrame(this.desk);
                this.myToolbar.add((AbstractAction)a);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void setSplash(JWindow splash) {
        this.mySplashScreen = splash;
    }

    public JWindow getSplash() {
        return this.mySplashScreen;
    }

    public ApplicationActionStateHandler getDefaultActionStateHandler() {
        return new DefaultActionStateHandler();
    }

    public boolean isFileNameValid(File file, String fileNamePath) {
        return IOUtil.canCreateFile(file);
    }

    void setupComponents(RmaArguments args) {
        String[] items;
        JDesktopPane desk = new JDesktopPane();
        desk.setDesktopManager(new DefaultDesktopManager());
        this.setDesktopPane(desk);
        RmaFrameSupport.removeRmaFrameListenerByClass(ApplicationActionStateController.class);
        RmaFrameSupport.addRmaFrameListener(new ApplicationActionStateController());
        this.createMenuBar();
        this.createToolBar();
        if (args != null && (items = args.getAdditionalToolbarItems()) != null) {
            this.createAdditionalToolbarItems(items);
        }
    }

    private class LogSettingsChangeListener
    implements RmaDefsPropertiesChangeListener {
        private LogSettingsChangeListener() {
        }

        @Override
        public void propertiesChange(RmaDefsPropertiesChangeEvent changeEvent) {
            LogConfig.getInstance().updateConfiguration();
            if (GuiServiceCenter.this.myLoggingFrame != null) {
                GuiServiceCenter.this.getLoggerTablePanel().updateTableFromRmaProperties();
            }
        }
    }

    private class OpenLogTask
    extends javax.swing.SwingWorker<LoggerTablePanel, Void> {
        private JDialog myDialog;

        OpenLogTask(JDialog progressDialog) {
            this.myDialog = progressDialog;
        }

        @Override
        protected LoggerTablePanel doInBackground() throws Exception {
            LoggerTablePanel loggerPanel = LoggerTablePanel.createSafely();
            return this.isCancelled() ? null : loggerPanel;
        }

        @Override
        protected void done() {
            LoggerTablePanel table;
            try {
                table = (LoggerTablePanel)this.get();
            }
            catch (Exception ex) {
                table = null;
            }
            if (table != null) {
                GuiServiceCenter.this.myLoggingFrame = this.createLogFrame(table);
                GuiServiceCenter.this.myLoggingFrame.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosed(InternalFrameEvent e) {
                        LoggerTablePanel table = GuiServiceCenter.this.getLoggerTablePanel();
                        table.unregisterOutput(LogConfig.getInstance().getHandler());
                        table.clearForm();
                        GuiServiceCenter.this.myLoggingFrame = null;
                    }
                });
                table.registerOutput(LogConfig.getInstance().getHandler());
                GuiServiceCenter.this.myLoggingFrame.setVisible(true);
                GuiServiceCenter.this.desk.add((Component)GuiServiceCenter.this.myLoggingFrame, "Center");
                GuiServiceCenter.setSelectedNoVeto(GuiServiceCenter.this.myLoggingFrame, true);
            }
            StatusPanel.getInstance().setStatusMsg("");
            this.myDialog.dispose();
        }

        private JInternalFrame createLogFrame(LoggerTablePanel table) {
            RmaFrameSupport frame = new RmaFrameSupport("Log");
            frame.getContentPane().add(table);
            if (!GuiServiceCenter.this.setWindowPosition(frame)) {
                frame.setSize(new Dimension(500, 300));
            }
            return frame;
        }
    }

    public static class DefaultActionStateHandler
    implements ApplicationActionStateHandler {
        @Override
        public boolean isApplicationActionSupported(ApplicationAction action) {
            return false;
        }
    }

    static class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("Exit");
            this.putValue("ShortDescription", "Exits the Rma application");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter guiSC = GuiServiceCenter.getInstance();
            JFrame mainWindow = guiSC.getMainWindow();
            if (guiSC.prepareForExit()) {
                if (mainWindow instanceof AbstractRmaPlugin) {
                    ((AbstractRmaPlugin)mainWindow).performExit();
                } else {
                    System.exit(0);
                }
            }
        }
    }

    static class SettingsAction
    extends AbstractAction {
        public SettingsAction() {
            super("Settings", RmaDefs.getImageIcon("settings_icon16.png"));
            this.putValue("ShortDescription", "Show Settings");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.getInstance().settingsAction();
        }
    }

    static class NavigatorToolAction
    extends AbstractAction {
        public NavigatorToolAction() {
            super("Navigator", RmaDefs.getImageIcon("compass24.png"));
            this.putValue("ShortDescription", "Show/hide the ERE Navigator");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiServiceCenter.getInstance().startNavigatorWindow();
        }
    }

    static class NavigatorWindowAction
    extends AbstractAction {
        public NavigatorWindowAction() {
            super("ERE Navigator", RmaDefs.getImageIcon("compass_16.png"));
            this.putValue("ShortDescription", "Show/hide the ERE Navigator");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.getInstance().startNavigatorWindow();
        }
    }

    static class DiffToolAction
    extends AbstractAction {
        public DiffToolAction() {
            super("Selection Tree Difference Detection Tool", RmaDefs.getImageIcon("components24.png"));
            this.putValue("ShortDescription", "Show Diff Tool");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.getInstance().diffToolAction();
        }
    }

    @Deprecated
    class LoggingWindowAction
    extends AbstractAction {
        public LoggingWindowAction() {
            super("Log");
            this.putValue("ShortDescription", "Opens the logger window");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.this.logAction();
        }
    }

    static class LogToolAction
    extends AbstractAction {
        public LogToolAction() {
            super("Log", RmaDefs.getImageIcon("form_blue.png"));
            this.putValue("ShortDescription", "Show Log");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.getInstance().logAction();
        }
    }

    public static class ImportMenuAction
    extends AbstractAction {
        public ImportMenuAction() {
            super("Import...");
            this.putValue("SmallIcon", RmaDefs.getImageIcon("import1_16.png"));
            this.putValue("SwingLargeIconKey", RmaDefs.getImageIcon("import1_24.png"));
            this.putValue("ShortDescription", "Import from file");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.getInstance().importFile();
        }
    }

    public static class ExportMenuAction
    extends AbstractAction {
        public ExportMenuAction() {
            super("Export...");
            this.putValue("SmallIcon", RmaDefs.getImageIcon("export1_16.png"));
            this.putValue("SwingLargeIconKey", RmaDefs.getImageIcon("export1_24.png"));
            this.putValue("ShortDescription", "Export to file");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 2));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.getInstance().exportFile();
        }
    }

    public static class SaveMenuAction
    extends AbstractAction {
        public SaveMenuAction() {
            super("Save");
            this.putValue("SmallIcon", RmaDefs.getImageIcon("disk_blue16.png"));
            this.putValue("SwingLargeIconKey", RmaDefs.getImageIcon("disk_blue24.png"));
            this.putValue("ShortDescription", "Save changes");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GuiServiceCenter.getInstance().save();
        }
    }
}

