/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import com.ericsson.ere.exception.ServiceException;

public class InvalidFieldException
extends ServiceException {
    private String myFieldName;
    private String myParameter;
    private String myValue;

    public InvalidFieldException(String fieldName) {
        super("Failed to initialize " + fieldName);
        this.myFieldName = fieldName;
    }

    public InvalidFieldException(String fieldName, String parameter, String value) {
        super(String.format("Failed to initialize %s because parameter %s has an invalid value '%s'.", fieldName, parameter, value));
        this.myFieldName = fieldName;
        this.myParameter = parameter;
        this.myValue = value;
    }

    public InvalidFieldException(String fieldName, String parameter, String value, String reason) {
        super(String.format("Failed to initialize %s because parameter %s has an invalid value '%s' (%s).", fieldName, parameter, value, reason));
        this.myFieldName = fieldName;
        this.myParameter = parameter;
        this.myValue = value;
    }

    public String getParameter() {
        return this.myParameter;
    }

    public String getParameterValue() {
        return this.myValue;
    }

    public String getFieldName() {
        return this.myFieldName;
    }
}

