/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import ericsson.ere.defs.CompoundFieldRepository;
import ericsson.ere.defs.FieldContextField;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepositoryCloner;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.ContextKey;
import java.util.List;
import java.util.Map;

public class FieldRepositoryWrapper
implements CompoundFieldRepository {
    private CompoundFieldRepository myFieldRepository;

    public FieldRepositoryWrapper(CompoundFieldRepository fieldRepository) {
        if (fieldRepository == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.myFieldRepository = fieldRepository;
    }

    public synchronized void swapRepository(CompoundFieldRepository fieldRepository) {
        if (fieldRepository == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.myFieldRepository = fieldRepository;
    }

    public synchronized void modifyAndSwapRepository(List<FieldHierarchyNode> removeList, List<FieldHierarchyNode> addList, List<FieldContextField> removeFieldList, List<FieldContextField> addFieldList) {
        FieldRepositoryCloner cloner = this.myFieldRepository.getCloner();
        if (removeList != null) {
            cloner.andRemove(removeList);
        }
        if (addList != null) {
            cloner.andAdd(addList);
        }
        if (removeFieldList != null) {
            cloner.andRemoveContextFields(removeFieldList);
        }
        if (addFieldList != null) {
            cloner.andAddContextFields(addFieldList);
        }
        this.swapRepository(cloner.makeClone());
    }

    @Override
    public String getSeparator() {
        return this.myFieldRepository.getSeparator();
    }

    @Override
    public FieldHierarchyNode getFieldByName(String name) {
        return this.myFieldRepository.getFieldByName(name);
    }

    @Override
    public List<String> getAllFieldNames() {
        return this.myFieldRepository.getAllFieldNames();
    }

    @Override
    public List<FieldHierarchyNode> getAllFields() {
        return this.myFieldRepository.getAllFields();
    }

    @Override
    public List<FieldHierarchyNode> getTopLevelFields() {
        return this.myFieldRepository.getTopLevelFields();
    }

    @Override
    public List<FieldDefinition> getTopLevelFieldDefinitions() {
        return this.myFieldRepository.getTopLevelFieldDefinitions();
    }

    @Override
    public FieldHierarchyNode getTopLevelFieldByName(String name) {
        return this.myFieldRepository.getTopLevelFieldByName(name);
    }

    @Override
    public List<FieldDefinition> getWorkingParameterFields() {
        return this.myFieldRepository.getWorkingParameterFields();
    }

    @Override
    public Map<String, FieldHierarchyNode> getServiceProviderContextFields(ContextKey key) {
        return this.myFieldRepository.getServiceProviderContextFields(key);
    }

    @Override
    public Map<String, FieldHierarchyNode> getRatingPlanContextFields(ContextKey key) {
        return this.myFieldRepository.getRatingPlanContextFields(key);
    }

    @Override
    public FieldRepositoryCloner getCloner() {
        return this.myFieldRepository.getCloner();
    }

    @Override
    public List<FieldContextField> getFieldContextFields() {
        return this.myFieldRepository.getFieldContextFields();
    }
}

