/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import com.ericsson.ere.exception.ServiceFieldException;
import ericsson.ere.defs.CompoundFieldRepository;
import ericsson.ere.defs.FieldContextField;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepositoryCloner;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.ContextKey;
import ericsson.ere.management.FieldContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FieldRepositoryWithContext
implements CompoundFieldRepository {
    private final CompoundFieldRepository myBaseFieldRepository;
    private final FieldContext myContext;
    private final Map<String, FieldHierarchyNode> myServiceProviderContextFields;
    private final Map<String, FieldHierarchyNode> myRatingPlanContextFields;

    public FieldRepositoryWithContext(CompoundFieldRepository fieldRepository, FieldContext context) {
        if (fieldRepository == null) {
            throw new IllegalArgumentException("Repository attribute must not be null.");
        }
        this.myBaseFieldRepository = fieldRepository;
        this.myContext = context;
        if (context != null) {
            Map<String, FieldHierarchyNode> serviceProviderContextFields = this.myBaseFieldRepository.getServiceProviderContextFields(context.getServiceProviderContextKey());
            this.myServiceProviderContextFields = serviceProviderContextFields != null ? serviceProviderContextFields : Collections.emptyMap();
            Map<String, FieldHierarchyNode> ratingPlanContextFields = this.myBaseFieldRepository.getRatingPlanContextFields(context.getRatingPlanContextKey());
            this.myRatingPlanContextFields = ratingPlanContextFields != null ? ratingPlanContextFields : Collections.emptyMap();
        } else {
            this.myServiceProviderContextFields = Collections.emptyMap();
            this.myRatingPlanContextFields = Collections.emptyMap();
        }
    }

    @Override
    public String getSeparator() {
        return this.myBaseFieldRepository.getSeparator();
    }

    @Override
    public FieldHierarchyNode getFieldByName(String name) {
        FieldHierarchyNode fieldHierarchyNode = this.myRatingPlanContextFields.get(name);
        if (fieldHierarchyNode == null) {
            fieldHierarchyNode = this.myServiceProviderContextFields.get(name);
        }
        return fieldHierarchyNode == null ? this.myBaseFieldRepository.getFieldByName(name) : fieldHierarchyNode;
    }

    @Override
    public List<String> getAllFieldNames() {
        HashSet<String> allFieldNames = new HashSet<String>();
        allFieldNames.addAll(this.myRatingPlanContextFields.keySet());
        allFieldNames.addAll(this.myServiceProviderContextFields.keySet());
        allFieldNames.addAll(this.myBaseFieldRepository.getAllFieldNames());
        return new ArrayList<String>(allFieldNames);
    }

    @Override
    public List<FieldHierarchyNode> getAllFields() {
        HashMap<String, FieldHierarchyNode> allFields = new HashMap<String, FieldHierarchyNode>();
        for (FieldHierarchyNode node : this.myRatingPlanContextFields.values()) {
            allFields.put(node.getCanonicalName(), node);
        }
        for (FieldHierarchyNode node : this.myServiceProviderContextFields.values()) {
            if (allFields.containsKey(node.getCanonicalName())) continue;
            allFields.put(node.getCanonicalName(), node);
        }
        for (FieldHierarchyNode node : this.myBaseFieldRepository.getAllFields()) {
            if (allFields.containsKey(node.getCanonicalName())) continue;
            allFields.put(node.getCanonicalName(), node);
        }
        return new ArrayList<FieldHierarchyNode>(allFields.values());
    }

    @Override
    public List<FieldHierarchyNode> getTopLevelFields() {
        HashMap<String, FieldHierarchyNode> topLevelFields = new HashMap<String, FieldHierarchyNode>();
        for (FieldHierarchyNode node : this.myRatingPlanContextFields.values()) {
            if (!this.isTopLevelField(node)) continue;
            topLevelFields.put(node.getCanonicalName(), node);
        }
        for (FieldHierarchyNode node : this.myServiceProviderContextFields.values()) {
            if (!this.isTopLevelField(node) || topLevelFields.containsKey(node.getCanonicalName())) continue;
            topLevelFields.put(node.getCanonicalName(), node);
        }
        for (FieldHierarchyNode node : this.myBaseFieldRepository.getTopLevelFields()) {
            if (topLevelFields.containsKey(node.getCanonicalName())) continue;
            topLevelFields.put(node.getCanonicalName(), node);
        }
        return new ArrayList<FieldHierarchyNode>(topLevelFields.values());
    }

    @Override
    public Map<String, FieldHierarchyNode> getServiceProviderContextFields(ContextKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, FieldHierarchyNode> getRatingPlanContextFields(ContextKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldRepositoryCloner getCloner() {
        return new RepositoryModifyingClonerWithContext();
    }

    @Override
    public List<FieldContextField> getFieldContextFields() {
        return this.myBaseFieldRepository.getFieldContextFields();
    }

    @Override
    public FieldHierarchyNode getTopLevelFieldByName(String name) {
        FieldHierarchyNode fieldHierarchyNode = this.myRatingPlanContextFields.get(name);
        FieldHierarchyNode fieldHierarchyNode2 = fieldHierarchyNode = this.isTopLevelField(fieldHierarchyNode) ? fieldHierarchyNode : null;
        if (fieldHierarchyNode == null) {
            fieldHierarchyNode = this.myServiceProviderContextFields.get(name);
            fieldHierarchyNode = this.isTopLevelField(fieldHierarchyNode) ? fieldHierarchyNode : null;
        }
        return fieldHierarchyNode == null ? this.myBaseFieldRepository.getTopLevelFieldByName(name) : fieldHierarchyNode;
    }

    @Override
    public List<FieldDefinition> getTopLevelFieldDefinitions() {
        HashMap<String, FieldDefinition> allTopLevelFieldDefinitions = new HashMap<String, FieldDefinition>();
        for (FieldHierarchyNode node : this.myRatingPlanContextFields.values()) {
            if (!this.isTopLevelField(node)) continue;
            allTopLevelFieldDefinitions.put(node.getCanonicalName(), (FieldDefinition)node);
        }
        for (FieldHierarchyNode node : this.myServiceProviderContextFields.values()) {
            if (!this.isTopLevelField(node) || allTopLevelFieldDefinitions.containsKey(node.getCanonicalName())) continue;
            allTopLevelFieldDefinitions.put(node.getCanonicalName(), (FieldDefinition)node);
        }
        for (FieldDefinition field : this.myBaseFieldRepository.getTopLevelFieldDefinitions()) {
            if (allTopLevelFieldDefinitions.containsKey(field.getCanonicalName())) continue;
            allTopLevelFieldDefinitions.put(field.getCanonicalName(), field);
        }
        return new ArrayList<FieldDefinition>(allTopLevelFieldDefinitions.values());
    }

    @Override
    public List<FieldDefinition> getWorkingParameterFields() {
        return this.myBaseFieldRepository.getWorkingParameterFields();
    }

    private boolean isTopLevelField(FieldHierarchyNode node) {
        return node != null && node.getParent() == null;
    }

    private class RepositoryModifyingClonerWithContext
    implements FieldRepositoryCloner {
        private FieldRepositoryCloner myBaseCloner;

        private RepositoryModifyingClonerWithContext() {
            this.myBaseCloner = FieldRepositoryWithContext.this.myBaseFieldRepository.getCloner();
        }

        @Override
        public FieldRepositoryCloner andAdd(List<FieldHierarchyNode> nodeList) {
            this.myBaseCloner.andAdd(nodeList);
            return this;
        }

        @Override
        public FieldRepositoryCloner andAddContextFields(List<FieldContextField> fieldList) {
            this.myBaseCloner.andAddContextFields(fieldList);
            return this;
        }

        @Override
        public FieldRepositoryCloner andRemove(List<FieldHierarchyNode> nodeList) {
            this.myBaseCloner.andRemove(nodeList);
            return this;
        }

        @Override
        public FieldRepositoryCloner andRemoveContextFields(List<FieldContextField> fieldList) {
            this.myBaseCloner.andRemoveContextFields(fieldList);
            return this;
        }

        @Override
        public synchronized CompoundFieldRepository makeClone() throws ServiceFieldException {
            CompoundFieldRepository fieldRepository = this.myBaseCloner.makeClone();
            return new FieldRepositoryWithContext(fieldRepository, FieldRepositoryWithContext.this.myContext);
        }
    }
}

