/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class EreDefs {
    public static final String XML_VERSION = "1.0";
    public static final String XML_ENCODING = "UTF-8";
    public static final String XML_STANDALONE = "no";
    public static final String XML_PROCESS_INSTRUCTION = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>";
    public static final String DTSTR_UNSIGNEDINT8 = "UnsignedInt8";
    public static final String DTSTR_UNSIGNEDINT16 = "UnsignedInt16";
    public static final String DTSTR_UNSIGNEDINT32 = "UnsignedInt32";
    public static final String DTSTR_TIME = "Time";
    public static final String DTSTR_DURATION = "Duration";
    public static final String DTSTR_OCTETSTRING = "OctetString";
    public static final String DTSTR_BCDSTRING = "BcdString";
    public static final String DTSTR_MONETARYUNITS = "MonetaryUnits";
    public static final String DTSTR_DECIMAL = "Decimal";
    public static final String DTSTR_STRING = "String";
    public static final String DTSTR_SHORT = "Short";
    public static final String DTSTR_INTEGER = "Integer";
    public static final String DTSTR_LONG = "Long";
    public static final String DTSTR_DOUBLE = "Double";
    public static final String DTSTR_BOOLEAN = "Boolean";
    public static final String DTSTR_DATE = "Date";
    public static final String DTSTR_UNSIGNEDSHORT = "UShort";
    public static final String DTSTR_UNSIGNEDINTEGER = "UInteger";
    public static final String DTSTR_UNSIGNEDLONG = "ULong";
    public static final String DTSTR_OBJECT = "Object";
    public static final String DTSTR_AMOUNT = "Amount";
    public static final String DTSTR_RATINGDECIMAL = "RatingDecimal";
    public static String[][] SDPConditionNames = new String[][]{{"FriendsAndFamily", "K"}, {"CallEvent", "Event"}};
    public static String[] dataTypeArray = new String[]{"UnsignedInt32", "UnsignedInt16", "UnsignedInt8", "MonetaryUnits", "Decimal", "Time", "String", "BcdString", "OctetString", "Short", "Integer", "Long", "Double", "Boolean", "Date", "UShort", "UInteger", "ULong", "Object", "Amount", "RatingDecimal"};
    public static final int UNSIGNEDINT32 = 0;
    public static final int UNSIGNEDINT16 = 1;
    public static final int UNSIGNEDINT8 = 2;
    public static final int MONETARYUNITS = 3;
    public static final int DECIMAL = 4;
    public static final int TIME = 5;
    public static final int STRING = 6;
    public static final int BCDSTRING = 7;
    public static final int OCTETSTRING = 8;
    public static final int SHORT = 9;
    public static final int INTEGER = 10;
    public static final int LONG = 11;
    public static final int DOUBLE = 12;
    public static final int BOOLEAN = 13;
    public static final int DATE = 14;
    public static final int USHORT = 15;
    public static final int UINTEGER = 16;
    public static final int ULONG = 17;
    public static final int OBJECT = 18;
    public static final int AMOUNT = 19;
    public static final int RATINGDECIMAL = 20;
    public static final char FNUTT = '\"';
    public static final String NL = System.getProperty("line.separator");
    public static final String defaultCondition = "GenericNumberList";
    public static final String defaultModifier = "Rate";
    public static final String tagText = "Text";
    public static final String TREE_EDIT_MSG_HEADER = "Tree edit message header";
    public static final String TREE_NODE_DELETE_MSG = "Do you want to delete the selected Node ? ";
    public static final String[] weekdays = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    public static final int NODE_TYPE_TARIFFTREE = 1;
    public static final int NODE_TYPE_CONDITION = 2;
    public static final int NODE_TYPE_NODE = 3;
    public static final int NODE_TYPE_LEAF = 4;
    public static final int NODE_TYPE_REPOSITORY = 5;
    public static final int NODE_TYPE_RATINGMETHOD = 6;
    public static final int NODE_TYPE_FIELDCONDITION = 7;
    public static final int NODE_TYPE_DATADESCRIPTION = 8;
    public static final int NODE_TYPE_METHOD = 9;
    public static final int NODE_TYPE_MODIFIERCLASS = 10;
    public static final int NODE_TYPE_FIELDDESCRIPTION = 11;
    public static final int NODE_TYPE_REPOSITORYOBJECT = 12;
    public static final int NODE_TYPE_STRUCTURE = 13;
    public static final int NODE_TYPE_BASECONDITION = 14;
    public static final int NODE_TYPE_GENERICCONDITION = 15;
    public static final int NODE_TYPE_TARIFFSTRUCTURES = 16;
    public static final int NODE_TYPE_NODES = 17;
    public static final int NODE_TYPE_MODIFIERS = 18;
    public static final String TAG_BUILTINDATE = "BuiltInDate";
    public static final String TAG_BUILTINDAYOFWEEK = "DayOfWeek";
    public static final String TAG_TARIFFSTRUCTURE = "TariffStructure";
    public static final String TAG_INEURO = "InEuro";
    public static final String TAG_DEFAULT_PRICE = "DefaultPrice";
    public static final String TAG_DEFAULT_INTERVAL = "DefaultInterval";
    public static final String TAG_DEFAULT_FEE = "DefaultFee";
    public static final String TAG_NODE = "Node";
    public static final String DISCOUNT = "Discount";
    public static final String CALLNEXTWHENFALSE = "CallNextWhenFalse";
    public static final String TAG_CONDITION = "Condition";
    public static final String TAG_DAYOFWEEK = "DayOfWeek";
    public static final String TAG_TEXT = "Text";
    public static final String TAG_FROM = "From";
    public static final String TAG_TO = "To";
    public static final String TAG_LONGVALUE = "LongValue";
    public static final String TAG_INTVALUE = "IntValue";
    public static final String TAG_SHORTVALUE = "ShortValue";
    public static final String TAG_ULONGVALUE = "ULongValue";
    public static final String TAG_UINTVALUE = "UIntValue";
    public static final String TAG_USHORTVALUE = "UShortValue";
    public static final String TAG_DOUBLEVALUE = "DoubleValue";
    public static final String TAG_RATINGDECIMALVALUE = "RatingDecimalValue";
    public static final String TAG_VALUE = "Value";
    public static final String TAG_DATE = "Date";
    public static final String TAG_TYPE = "Type";
    public static final String TAG_OPERATOR = "Operator";
    public static final String TAG_FIELD = "Field";
    public static final String TAG_NUMBER = "Number";
    public static final String TAG_TARIFF = "Tariff";
    public static final String TAG_PRICE = "Price";
    public static final String TAG_INTERVAL = "Interval";
    public static final String TAG_FACTOR = "Factor";
    public static final String TAG_DEFAULT_LDAP_HOST = "LdapHost";
    public static final String TAG_DEFAULT_LDAP_PORT = "LdapPort";
    public static final String TAG_DEFAULT_LDAP_ROOT = "LdapRoot";
    public static final String TAG_DEFAULT_LDAP_CONTEXT = "LdapContext";
    public static final String TAG_DEFAULT_LDAP_PASSWORD = "LdapContextInformation";
    public static final String TAG_RATING_MANAGER_FILE = "RatingManagerFile";
    public static final String TAG_DEFAULT_OWNER_ID = "ownerId";
    public static final String TAG_DEFAULT_GROUP_ID = "groupId";
    public static final String TAG_DEFAULT_PERMISSIONS = "permissions";
    public static final String TAG_DEFAULT_SHARE_TREE = "shareTree";
    public static final String TAG_DEFAULT_FILE_PORT = "filePort";
    public static final String TAG_SERVICE_LIST = "ServiceList";
    public static final String TAG_SERVICE = "Service";
    public static final String TAG_SERVICE_PROVIDER_LIST = "ServiceProviderList";
    public static final String TAG_SERVICE_PROVIDER = "ServiceProvider";
    public static final String TAG_RATING_PLAN = "RatingPlan";
    public static final String TAG_RATING_PERIOD = "RatingPeriod";
    public static final String TAG_UTILITY_LIST = "UtilityList";
    public static final String TAG_UTILITY = "Utility";
    private static EreDefs ereDefs = new EreDefs();
    public static Map<String, String> myErrorCodes = new Hashtable<String, String>();

    private EreDefs() {
    }

    public static String getErrorString(String aKey) {
        String value = myErrorCodes.get(aKey);
        if (value == null) {
            return "Error. No message for " + aKey + ".";
        }
        return value;
    }

    public static synchronized EreDefs getInstance() {
        return ereDefs;
    }

    public static int getDataType(String dataType) {
        for (int ii = 0; ii < dataTypeArray.length; ++ii) {
            if (!dataType.toLowerCase(Locale.US).equals(dataTypeArray[ii].toLowerCase(Locale.US))) continue;
            return ii;
        }
        return 6;
    }

    public static String getDataTypeFromIntValue(int value) {
        return dataTypeArray[value];
    }

    public static Double monetaryUnitStringToDouble(String monetaryUnitStr) {
        int i1 = monetaryUnitStr.indexOf(58);
        int i2 = monetaryUnitStr.indexOf(58, i1 + 1);
        long numbers = Long.parseLong(monetaryUnitStr.substring(0, i1));
        int numberOfDecimals = i2 > 0 ? (int)Math.pow(10.0, Double.parseDouble(monetaryUnitStr.substring(i1 + 1, i2))) : (int)Math.pow(10.0, Double.parseDouble(monetaryUnitStr.substring(i1 + 1)));
        return new Double((double)numbers / (double)numberOfDecimals);
    }

    static {
        ResourceBundle bundle2 = ResourceBundle.getBundle("ericsson.ere.defs.ErrorCodes");
        Enumeration<String> keys = bundle2.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            myErrorCodes.put(key, bundle2.getString(key));
        }
    }
}

