/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.defs;

import com.ericsson.ere.exception.ServiceFieldException;
import ericsson.ere.defs.CompoundFieldRepository;
import ericsson.ere.defs.FieldContextField;
import ericsson.ere.defs.FieldCreationManager;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepositoryCloner;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.ContextKey;
import ericsson.ere.management.FieldContext;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class DefaultFieldRepository
implements CompoundFieldRepository {
    private static final String FIELD_SCHEMA_FILE = "/config/ere-service-field-schema.xsd";
    private static final String TAG_FIELD = "Field";
    private static final String TAG_FIELD_STRUCTURE = "FieldStructure";
    private static final String TAG_GROUP = "Group";
    private static final String TAG_FIELDS = "Fields";
    private static final String TAG_CONTEXT_DEFINITION = "ContextDefinition";
    private static final String TAG_SERVICE_PROVIDER_FIELDS_LIST = "ServiceProviderFieldsList";
    private static final String TAG_SERVICE_PROVIDER_FIELDS = "ServiceProviderFields";
    private static final String TAG_RATINGPLAN_FIELDS_LIST = "RatingPlanFieldsList";
    private static final String TAG_RATINGPLAN_FIELDS = "RatingPlanFields";
    private static final String ATTRUBUTE_KEY_FIELD = "keyField";
    private static final String ATTRIBUTE_SEPARATOR = "Separator";
    private static final String ATTRIBUTE_KEY = "key";
    private final String mySeparator;
    private final Map<String, FieldHierarchyNode> myFields;
    private final List<FieldDefinition> myWorkingFields;
    private final Map<ContextKey, FieldContextFieldsMap> myServiceProviderContextFieldsMap;
    private final Map<ContextKey, FieldContextFieldsMap> myRatingPlanContextFieldsMap;

    @Override
    public List<FieldContextField> getFieldContextFields() {
        ArrayList<FieldContextField> fieldContextFields = new ArrayList<FieldContextField>();
        for (FieldContextFieldsMap value : this.myServiceProviderContextFieldsMap.values()) {
            fieldContextFields.addAll(value.getContextFields());
        }
        for (FieldContextFieldsMap value : this.myRatingPlanContextFieldsMap.values()) {
            fieldContextFields.addAll(value.getContextFields());
        }
        return fieldContextFields;
    }

    public DefaultFieldRepository(Element xml) throws ServiceFieldException {
        this(xml, null, null);
    }

    public DefaultFieldRepository(Element xml, Map<String, List<String>> contextFieldBelongingMap, FieldCreationManager fieldManager) throws ServiceFieldException {
        Validator validator = this.createValidator();
        this.myFields = new HashMap<String, FieldHierarchyNode>();
        this.myWorkingFields = new ArrayList<FieldDefinition>();
        String separator = null;
        this.myServiceProviderContextFieldsMap = new HashMap<ContextKey, FieldContextFieldsMap>();
        this.myRatingPlanContextFieldsMap = new HashMap<ContextKey, FieldContextFieldsMap>();
        if (xml != null) {
            Element serviceProviderFieldsListXml;
            Element contextFieldsXml;
            Element contextDefinitionXml;
            Element fieldsXml = XMLUtil.getNamedElement(TAG_FIELDS, xml.getChildNodes());
            if (fieldsXml != null) {
                separator = fieldsXml.getAttribute(ATTRIBUTE_SEPARATOR);
                this.parseFieldsXml(fieldsXml, null, separator, fieldManager, validator);
            }
            if ((contextDefinitionXml = XMLUtil.getNamedElement(TAG_CONTEXT_DEFINITION, xml.getChildNodes())) != null && (contextFieldsXml = XMLUtil.getNamedElement(TAG_FIELDS, contextDefinitionXml.getChildNodes())) != null) {
                this.parseFieldsXml(contextFieldsXml, contextFieldBelongingMap, separator, fieldManager, validator);
            }
            if ((serviceProviderFieldsListXml = XMLUtil.getNamedElement(TAG_SERVICE_PROVIDER_FIELDS_LIST, xml.getChildNodes())) != null) {
                List<Element> serviceProviderFieldsXmls = XMLUtil.getElementNodesNamed(TAG_SERVICE_PROVIDER_FIELDS, serviceProviderFieldsListXml.getChildNodes());
                for (Element serviceProviderFieldsXml : serviceProviderFieldsXmls) {
                    String serviceProviderKey = serviceProviderFieldsXml.getAttribute(ATTRIBUTE_KEY);
                    FieldContext currentContext = new FieldContext(serviceProviderKey);
                    this.myServiceProviderContextFieldsMap.put(currentContext.getServiceProviderContextKey(), new FieldContextFieldsMap(currentContext, this.createFieldsMap(serviceProviderFieldsXml, fieldManager, validator)));
                    Element ratingPlanFieldsListXml = XMLUtil.getNamedElement(TAG_RATINGPLAN_FIELDS_LIST, serviceProviderFieldsXml.getChildNodes());
                    if (ratingPlanFieldsListXml == null) continue;
                    List<Element> ratingPlanFieldsXmls = XMLUtil.getElementNodesNamed(TAG_RATINGPLAN_FIELDS, ratingPlanFieldsListXml.getChildNodes());
                    for (Element ratingPlanFieldsXml : ratingPlanFieldsXmls) {
                        String ratingPlanKey = ratingPlanFieldsXml.getAttribute(ATTRIBUTE_KEY);
                        currentContext = new FieldContext(serviceProviderKey, ratingPlanKey);
                        this.myRatingPlanContextFieldsMap.put(currentContext.getRatingPlanContextKey(), new FieldContextFieldsMap(currentContext, this.createFieldsMap(ratingPlanFieldsXml, fieldManager, validator)));
                    }
                }
            }
        }
        this.mySeparator = StringUtil.isEmptyString(separator) ? null : separator;
        this.validateFieldRepository();
    }

    private Map<String, FieldHierarchyNode> createFieldsMap(Element fieldsXml, FieldCreationManager fieldManager, Validator validator) {
        HashMap<String, FieldHierarchyNode> fields = new HashMap<String, FieldHierarchyNode>();
        Element fieldsElement = XMLUtil.getNamedElement(TAG_FIELDS, fieldsXml.getChildNodes());
        if (fieldsElement != null) {
            for (Element fieldElement : XMLUtil.getElementNodesNamed(TAG_FIELD, fieldsElement.getChildNodes())) {
                this.validateFieldXmlSchema(fieldElement, validator);
                FieldDefinition.DefaultFieldConfiguration config = new FieldDefinition.DefaultFieldConfiguration(fieldElement, null, null);
                FieldDefinition fieldDefinition = FieldDefinition.createField(config, fieldManager);
                DefaultFieldRepository.putFieldIntoMap(fields, fieldDefinition);
            }
        }
        return fields;
    }

    private DefaultFieldRepository(String separator, Map<String, FieldHierarchyNode> nodeMap, List<FieldDefinition> workingFields, Map<ContextKey, FieldContextFieldsMap> serviceProviderContextFieldsMap, Map<ContextKey, FieldContextFieldsMap> ratingPlanContextFieldsMap) throws ServiceFieldException {
        this.mySeparator = separator;
        this.myFields = nodeMap;
        this.myWorkingFields = workingFields;
        this.myServiceProviderContextFieldsMap = serviceProviderContextFieldsMap;
        this.myRatingPlanContextFieldsMap = ratingPlanContextFieldsMap;
        this.validateFieldRepository();
    }

    private Validator createValidator() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Class<?> class1 = this.getClass();
        InputStream resourceAsStream = class1.getResourceAsStream(FIELD_SCHEMA_FILE);
        StreamSource streamSource = new StreamSource(resourceAsStream);
        Schema schema = null;
        try {
            schema = factory.newSchema(streamSource);
        }
        catch (SAXException e) {
            throw new ServiceFieldException("Service Fields schema instantiation failed.", e);
        }
        return schema.newValidator();
    }

    @Override
    public String getSeparator() {
        return this.mySeparator;
    }

    @Override
    public FieldHierarchyNode getFieldByName(String path) {
        return this.myFields.get(path);
    }

    @Override
    public List<String> getAllFieldNames() {
        return new ArrayList<String>(this.myFields.keySet());
    }

    @Override
    public List<FieldHierarchyNode> getAllFields() {
        return new ArrayList<FieldHierarchyNode>(this.myFields.values());
    }

    @Override
    public List<FieldHierarchyNode> getTopLevelFields() {
        ArrayList<FieldHierarchyNode> list = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode node : this.myFields.values()) {
            if (!this.isTopLevelField(node)) continue;
            list.add(node);
        }
        return list;
    }

    @Override
    public List<FieldDefinition> getTopLevelFieldDefinitions() {
        ArrayList<FieldDefinition> list = new ArrayList<FieldDefinition>();
        for (FieldHierarchyNode node : this.myFields.values()) {
            if (!node.isLeaf() || !this.isTopLevelField(node)) continue;
            list.add((FieldDefinition)node);
        }
        return list;
    }

    @Override
    public FieldHierarchyNode getTopLevelFieldByName(String name) {
        FieldHierarchyNode node = this.myFields.get(name);
        if (!this.isTopLevelField(node)) {
            node = null;
        }
        return node;
    }

    @Override
    public List<FieldDefinition> getWorkingParameterFields() {
        return Collections.unmodifiableList(this.myWorkingFields);
    }

    private boolean isTopLevelField(FieldHierarchyNode node) {
        return node != null && node.getParent() == null;
    }

    private void validateFieldXmlSchema(Element node, Validator validator) throws ServiceFieldException {
        try {
            validator.validate(new DOMSource(node));
        }
        catch (SAXException ex) {
            throw new ServiceFieldException("Service Fields schema validation failed.", ex);
        }
        catch (IOException ex) {
            throw new ServiceFieldException("Service Fields schema validation failed.", ex);
        }
    }

    private void parseFieldsXml(Element xml, Map<String, List<String>> contextFieldBelongingMap, String separator, FieldCreationManager fieldManager, Validator validator) throws ServiceFieldException {
        FieldDefinition.DefaultFieldConfiguration config;
        for (Element fieldElement : XMLUtil.getElementNodesNamed(TAG_FIELD, xml.getChildNodes())) {
            this.validateFieldXmlSchema(fieldElement, validator);
            config = new FieldDefinition.DefaultFieldConfiguration(fieldElement, this.getContexNamesForField(fieldElement, contextFieldBelongingMap), null);
            FieldDefinition fieldDefinition = FieldDefinition.createField(config, fieldManager);
            this.addFieldToRepo(fieldDefinition);
        }
        for (Element groupElement : XMLUtil.getElementNodesNamed(TAG_GROUP, xml.getChildNodes())) {
            this.validateFieldXmlSchema(groupElement, validator);
            String keyFieldAttribute = XMLUtil.getAttributeFromElement(groupElement, ATTRUBUTE_KEY_FIELD, null);
            this.addGroupElements(groupElement, keyFieldAttribute, contextFieldBelongingMap, fieldManager);
        }
        for (Element fieldStructureElement : XMLUtil.getElementNodesNamed(TAG_FIELD_STRUCTURE, xml.getChildNodes())) {
            this.validateFieldXmlSchema(fieldStructureElement, validator);
            config = new FieldDefinition.DefaultFieldConfiguration(fieldStructureElement, this.getContexNamesForField(fieldStructureElement, contextFieldBelongingMap), null);
            FieldStructure fieldStructure = FieldStructure.createFieldStructure(config, separator, fieldManager);
            this.addFieldStructureToRepo(fieldStructure);
        }
    }

    private List<String> getContexNamesForField(Element fieldElement, Map<String, List<String>> contextFieldBelongingMap) {
        List<String> contextNames = null;
        String fieldName = fieldElement.getAttribute("Name");
        if (contextFieldBelongingMap != null && (contextNames = contextFieldBelongingMap.get(fieldName)) == null) {
            contextNames = Collections.emptyList();
        }
        return contextNames;
    }

    private void addGroupElements(Element groupElement, String keyField, Map<String, List<String>> contextFieldBelongingMap, FieldCreationManager fieldManager) {
        for (Element fieldElement : XMLUtil.getElementNodesNamed(TAG_FIELD, groupElement.getChildNodes())) {
            FieldDefinition.DefaultFieldConfiguration config = new FieldDefinition.DefaultFieldConfiguration(fieldElement, this.getContexNamesForField(fieldElement, contextFieldBelongingMap), keyField);
            FieldDefinition fieldDefinition = FieldDefinition.createField(config, fieldManager);
            this.addFieldToRepo(fieldDefinition);
        }
        for (Element subGroupElement : XMLUtil.getElementNodesNamed(TAG_GROUP, groupElement.getChildNodes())) {
            String keyFieldAttribute = XMLUtil.getAttributeFromElement(subGroupElement, ATTRUBUTE_KEY_FIELD, null);
            this.addGroupElements(subGroupElement, keyFieldAttribute, contextFieldBelongingMap, fieldManager);
        }
    }

    private void addFieldToRepo(FieldDefinition field) {
        if (this.isWorkingField(field)) {
            this.myWorkingFields.add(field);
        } else {
            DefaultFieldRepository.putFieldIntoMap(this.myFields, field);
        }
    }

    private boolean isWorkingField(FieldDefinition field) {
        String parameterType = field.getParameterType();
        return "WORKING".equalsIgnoreCase(parameterType) || "WorkingParameter".equalsIgnoreCase(parameterType);
    }

    private void addFieldStructureToRepo(FieldStructure fieldStructure) {
        DefaultFieldRepository.putFieldIntoMap(this.myFields, fieldStructure);
        for (FieldHierarchyNode node : fieldStructure.getChildren()) {
            if (node.isLeaf()) {
                this.addFieldToRepo((FieldDefinition)node);
                continue;
            }
            this.addFieldStructureToRepo((FieldStructure)node);
        }
    }

    private void validateFieldRepository() throws ServiceFieldException {
        Collection<FieldHierarchyNode> allFields = this.myFields.values();
        List<FieldHierarchyNode> topLevelFields = this.getTopLevelFields();
        this.checkValidSeparator();
        DefaultFieldRepository.checkHierarchicalFieldsContainSameParameterType(allFields);
        DefaultFieldRepository.checkKeyFieldsInStructure(topLevelFields);
        DefaultFieldRepository.checkComplexStructuresOnlyAllowedOnTopLevel(topLevelFields);
    }

    private List<FieldHierarchyNode> getFieldStructures() {
        ArrayList<FieldHierarchyNode> list = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode node : this.myFields.values()) {
            if (node.isLeaf()) continue;
            list.add(node);
        }
        return list;
    }

    private void checkValidSeparator() throws ServiceFieldException {
        if (this.mySeparator == null && this.getFieldStructures().size() > 0) {
            throw new ServiceFieldException("Hierarchical fields not allowed when field separator not set.");
        }
    }

    private static void checkHierarchicalFieldsContainSameParameterType(Collection<FieldHierarchyNode> nodeList) throws ServiceFieldException {
        for (FieldHierarchyNode node : nodeList) {
            if (node.isLeaf() || DefaultFieldRepository.getAllSubParameterTypes(node).size() <= 1) continue;
            throw new ServiceFieldException("Parameter type must be the same for all sub fields in a hierarchical structure - " + node.getFieldName() + ".");
        }
    }

    private static Set<String> getAllSubParameterTypes(FieldHierarchyNode field) {
        HashSet<String> types = new HashSet<String>();
        for (FieldHierarchyNode node : field.getChildren()) {
            if (node.isLeaf()) {
                types.add(((FieldDefinition)node).getParameterType());
                continue;
            }
            Set<String> subTypes = DefaultFieldRepository.getAllSubParameterTypes(node);
            types.addAll(subTypes);
        }
        return types;
    }

    private static void checkKeyFieldsInStructure(Collection<FieldHierarchyNode> nodeList) throws ServiceFieldException {
        for (FieldHierarchyNode node : nodeList) {
            if (node.isLeaf()) continue;
            DefaultFieldRepository.checkThatKeyFieldExistIfMapOrSet(node);
            DefaultFieldRepository.checkKeyFieldsInStructure(node.getChildren());
        }
    }

    private static void checkThatKeyFieldExistIfMapOrSet(FieldHierarchyNode field) throws ServiceFieldException {
        int keysFound = 0;
        for (FieldHierarchyNode child : field.getChildren()) {
            if (!child.isKey()) continue;
            if (child.getComplexType() != FieldHierarchyNode.ComplexType.NONE) {
                throw new ServiceFieldException("All key fields in field structure: " + field.getFieldName() + ", must be of plain type.");
            }
            ++keysFound;
        }
        switch (field.getComplexType()) {
            case MAP: {
                if (keysFound != 0) break;
                throw new ServiceFieldException("No key fields found in map field structure: " + field.getFieldName() + ".");
            }
            case SET: {
                break;
            }
            default: {
                if (keysFound == 0) break;
                throw new ServiceFieldException("Key fields not allowed in field structure: " + field.getFieldName() + ".");
            }
        }
    }

    private static void checkComplexStructuresOnlyAllowedOnTopLevel(Collection<FieldHierarchyNode> nodeList) {
        for (FieldHierarchyNode node : nodeList) {
            if (node.isLeaf()) continue;
            if (node.getComplexType() != FieldHierarchyNode.ComplexType.NONE) {
                DefaultFieldRepository.checkNoStructures(node.getChildren());
                continue;
            }
            DefaultFieldRepository.checkNoComplexStructures(node.getChildren());
        }
    }

    private static void checkNoStructures(List<FieldHierarchyNode> nodeList) {
        for (FieldHierarchyNode node : nodeList) {
            if (node.isLeaf()) continue;
            throw new ServiceFieldException("Complex field structures only allowed on field top level.");
        }
    }

    private static void checkNoComplexStructures(List<FieldHierarchyNode> nodeList) {
        for (FieldHierarchyNode node : nodeList) {
            if (node.isLeaf()) continue;
            if (node.getComplexType() != FieldHierarchyNode.ComplexType.NONE) {
                throw new ServiceFieldException("Complex field structures only allowed on field top level.");
            }
            DefaultFieldRepository.checkNoComplexStructures(node.getChildren());
        }
    }

    private static void putFieldIntoMap(Map<String, FieldHierarchyNode> fieldMap, FieldHierarchyNode field) {
        String fieldName = field.getCanonicalName();
        FieldHierarchyNode previousValue = fieldMap.put(fieldName, field);
        if (previousValue != null) {
            boolean legacyField;
            boolean bl = legacyField = field.getParent() == null && field.isLeaf();
            if (!legacyField) {
                throw new ServiceFieldException("Name not unique in its scope - " + fieldName + ".");
            }
        }
    }

    @Override
    public FieldRepositoryCloner getCloner() {
        return new FieldRepositoryModifyingCloner();
    }

    @Override
    public Map<String, FieldHierarchyNode> getServiceProviderContextFields(ContextKey key) {
        return this.myServiceProviderContextFieldsMap.get(key) != null ? new HashMap<String, FieldHierarchyNode>(this.myServiceProviderContextFieldsMap.get(key).getFields()) : null;
    }

    @Override
    public Map<String, FieldHierarchyNode> getRatingPlanContextFields(ContextKey key) {
        return this.myRatingPlanContextFieldsMap.get(key) != null ? new HashMap<String, FieldHierarchyNode>(this.myRatingPlanContextFieldsMap.get(key).getFields()) : null;
    }

    private static final class FieldContextFieldsMap {
        private final FieldContext myContext;
        private final Map<String, FieldHierarchyNode> myFields;

        FieldContextFieldsMap(FieldContext context, Map<String, FieldHierarchyNode> fields) {
            this.myContext = context;
            this.myFields = fields;
        }

        Map<String, FieldHierarchyNode> getFields() {
            return this.myFields;
        }

        FieldContext getContext() {
            return this.myContext;
        }

        List<FieldContextField> getContextFields() {
            ArrayList<FieldContextField> contextFields = new ArrayList<FieldContextField>();
            for (FieldHierarchyNode node : this.myFields.values()) {
                contextFields.add(new FieldContextField(node, this.myContext));
            }
            return contextFields;
        }
    }

    public class FieldRepositoryModifyingCloner
    implements FieldRepositoryCloner {
        private List<FieldHierarchyNode> myNodeListAdd = Collections.emptyList();
        private List<FieldHierarchyNode> myNodeListRemove = Collections.emptyList();
        private List<FieldContextField> myContextFieldsListAdd = Collections.emptyList();
        private List<FieldContextField> myContextFieldsListRemove = Collections.emptyList();

        private FieldRepositoryModifyingCloner() {
        }

        @Override
        public FieldRepositoryModifyingCloner andAdd(List<FieldHierarchyNode> nodeList) {
            if (nodeList == null) {
                throw new IllegalArgumentException("Node list parameter must not be null.");
            }
            if (this.myNodeListAdd.isEmpty()) {
                this.myNodeListAdd = new ArrayList<FieldHierarchyNode>(nodeList);
            } else {
                this.myNodeListAdd.addAll(nodeList);
            }
            return this;
        }

        @Override
        public FieldRepositoryCloner andAddContextFields(List<FieldContextField> fieldList) {
            if (fieldList == null) {
                throw new IllegalArgumentException("Field list parameter must not be null.");
            }
            if (this.myContextFieldsListAdd.isEmpty()) {
                this.myContextFieldsListAdd = new ArrayList<FieldContextField>(fieldList);
            } else {
                this.myContextFieldsListAdd.addAll(fieldList);
            }
            return this;
        }

        @Override
        public FieldRepositoryModifyingCloner andRemove(List<FieldHierarchyNode> nodeList) {
            if (nodeList == null) {
                throw new IllegalArgumentException("Node list parameter must not be null.");
            }
            if (this.myNodeListRemove.isEmpty()) {
                this.myNodeListRemove = new ArrayList<FieldHierarchyNode>(nodeList);
            } else {
                this.myNodeListRemove.addAll(nodeList);
            }
            return this;
        }

        @Override
        public FieldRepositoryCloner andRemoveContextFields(List<FieldContextField> fieldList) {
            if (fieldList == null) {
                throw new IllegalArgumentException("Field list parameter must not be null.");
            }
            if (this.myContextFieldsListRemove.isEmpty()) {
                this.myContextFieldsListRemove = new ArrayList<FieldContextField>(fieldList);
            } else {
                this.myContextFieldsListRemove.addAll(fieldList);
            }
            return this;
        }

        @Override
        public synchronized DefaultFieldRepository makeClone() throws ServiceFieldException {
            HashMap<String, FieldHierarchyNode> fieldMap = new HashMap<String, FieldHierarchyNode>(DefaultFieldRepository.this.myFields);
            ArrayList<FieldDefinition> workingFields = new ArrayList<FieldDefinition>(DefaultFieldRepository.this.myWorkingFields);
            HashMap<ContextKey, FieldContextFieldsMap> serviceProviderContextFieldsMap = new HashMap<ContextKey, FieldContextFieldsMap>();
            for (Map.Entry entry : DefaultFieldRepository.this.myServiceProviderContextFieldsMap.entrySet()) {
                serviceProviderContextFieldsMap.put((ContextKey)entry.getKey(), new FieldContextFieldsMap(((FieldContextFieldsMap)entry.getValue()).getContext(), new HashMap<String, FieldHierarchyNode>(((FieldContextFieldsMap)entry.getValue()).getFields())));
            }
            HashMap<ContextKey, FieldContextFieldsMap> ratingPlanContextFieldsMap = new HashMap<ContextKey, FieldContextFieldsMap>();
            for (Map.Entry entry : DefaultFieldRepository.this.myRatingPlanContextFieldsMap.entrySet()) {
                ratingPlanContextFieldsMap.put((ContextKey)entry.getKey(), new FieldContextFieldsMap(((FieldContextFieldsMap)entry.getValue()).getContext(), new HashMap<String, FieldHierarchyNode>(((FieldContextFieldsMap)entry.getValue()).getFields())));
            }
            List<FieldDefinition> list = this.extractWorkingFieldsFromList(this.myNodeListAdd);
            workingFields.addAll(list);
            this.putFieldsIntoMap(fieldMap, this.myNodeListAdd);
            this.putContextFieldsIntoMaps(serviceProviderContextFieldsMap, ratingPlanContextFieldsMap);
            List<FieldDefinition> list2 = this.extractWorkingFieldsFromList(this.myNodeListRemove);
            workingFields.removeAll(list2);
            this.removeFieldsFromMap(fieldMap, this.myNodeListRemove);
            this.removeContextFieldsFromMaps(serviceProviderContextFieldsMap, ratingPlanContextFieldsMap);
            return new DefaultFieldRepository(DefaultFieldRepository.this.mySeparator, fieldMap, workingFields, serviceProviderContextFieldsMap, ratingPlanContextFieldsMap);
        }

        private void removeContextFieldsFromMaps(Map<ContextKey, FieldContextFieldsMap> serviceProviderContextFieldsMap, Map<ContextKey, FieldContextFieldsMap> ratingPlanContextFieldsMap) {
            if (this.myContextFieldsListRemove != null) {
                for (FieldContextField contextField : this.myContextFieldsListRemove) {
                    Map<String, FieldHierarchyNode> fieldMap;
                    if (contextField.getFieldContext().isServiceProviderField()) {
                        fieldMap = serviceProviderContextFieldsMap.get(contextField.getFieldContext().getServiceProviderContextKey()).getFields();
                        if (fieldMap == null) continue;
                        fieldMap.remove(contextField.getNode().getCanonicalName());
                        if (!fieldMap.isEmpty()) continue;
                        serviceProviderContextFieldsMap.remove(contextField.getFieldContext().getServiceProviderContextKey());
                        continue;
                    }
                    fieldMap = ratingPlanContextFieldsMap.get(contextField.getFieldContext().getRatingPlanContextKey()).getFields();
                    if (fieldMap == null) continue;
                    fieldMap.remove(contextField.getNode().getCanonicalName());
                    if (!fieldMap.isEmpty()) continue;
                    ratingPlanContextFieldsMap.remove(contextField.getFieldContext().getRatingPlanContextKey());
                }
            }
        }

        private void putContextFieldsIntoMaps(Map<ContextKey, FieldContextFieldsMap> serviceProviderContextFieldsMap, Map<ContextKey, FieldContextFieldsMap> ratingPlanContextFieldsMap) {
            if (this.myContextFieldsListAdd != null) {
                for (FieldContextField contextField : this.myContextFieldsListAdd) {
                    Map<String, FieldHierarchyNode> ratingPlanContextFields;
                    if (contextField.getFieldContext().isServiceProviderField()) {
                        Map<String, FieldHierarchyNode> serviceProviderContextFields;
                        Map<String, FieldHierarchyNode> map = serviceProviderContextFields = serviceProviderContextFieldsMap.get(contextField.getFieldContext().getServiceProviderContextKey()) != null ? serviceProviderContextFieldsMap.get(contextField.getFieldContext().getServiceProviderContextKey()).getFields() : null;
                        if (serviceProviderContextFields == null) {
                            serviceProviderContextFields = new HashMap<String, FieldHierarchyNode>();
                            serviceProviderContextFieldsMap.put(contextField.getFieldContext().getServiceProviderContextKey(), new FieldContextFieldsMap(contextField.getFieldContext(), serviceProviderContextFields));
                        }
                        serviceProviderContextFields.put(contextField.getNode().getCanonicalName(), contextField.getNode());
                        continue;
                    }
                    Map<String, FieldHierarchyNode> map = ratingPlanContextFields = ratingPlanContextFieldsMap.get(contextField.getFieldContext().getRatingPlanContextKey()) != null ? ratingPlanContextFieldsMap.get(contextField.getFieldContext().getRatingPlanContextKey()).getFields() : null;
                    if (ratingPlanContextFields == null) {
                        ratingPlanContextFields = new HashMap<String, FieldHierarchyNode>();
                        ratingPlanContextFieldsMap.put(contextField.getFieldContext().getRatingPlanContextKey(), new FieldContextFieldsMap(contextField.getFieldContext(), ratingPlanContextFields));
                    }
                    ratingPlanContextFields.put(contextField.getNode().getCanonicalName(), contextField.getNode());
                }
            }
        }

        private List<FieldDefinition> extractWorkingFieldsFromList(List<FieldHierarchyNode> fields) {
            ArrayList<FieldDefinition> extractedWorkingFields = new ArrayList<FieldDefinition>();
            for (FieldHierarchyNode field : fields) {
                if (!field.isLeaf() || !DefaultFieldRepository.this.isWorkingField((FieldDefinition)field)) continue;
                extractedWorkingFields.add((FieldDefinition)field);
            }
            fields.removeAll(extractedWorkingFields);
            return extractedWorkingFields;
        }

        private void putFieldsIntoMap(Map<String, FieldHierarchyNode> fieldMap, List<FieldHierarchyNode> fieldList) {
            for (FieldHierarchyNode field : fieldList) {
                DefaultFieldRepository.putFieldIntoMap(fieldMap, field);
                if (field.isLeaf()) continue;
                this.putFieldsIntoMap(fieldMap, field.getChildren());
            }
        }

        private void removeFieldsFromMap(Map<String, FieldHierarchyNode> fieldMap, List<FieldHierarchyNode> fieldList) {
            for (FieldHierarchyNode node : fieldList) {
                fieldMap.remove(node.getCanonicalName());
                if (node.isLeaf()) continue;
                this.removeFieldsFromMap(fieldMap, node.getChildren());
            }
        }
    }
}

