/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype.factory;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.datatype.LazyEvaluatedERETime;
import com.ericsson.ere.defs.ClassRepositoryUser;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.parser.DefaultExpressionParserHandler;
import com.ericsson.ere.expression.parser.DefaultExpressionParserOptions;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.selectiontree.modifiers.mfo.ResolvingInfixExpressionFormatter;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.DateUtil;

public class LazyEvaluatedERETimeClassFactory
implements ValueClassFactory,
ClassRepositoryUser {
    private ClassRepository myRepository;
    private FieldDefinition myField;

    public LazyEvaluatedERETimeClassFactory createCopyWithField(FieldDefinition field) {
        LazyEvaluatedERETimeClassFactory newFactory = new LazyEvaluatedERETimeClassFactory();
        newFactory.myRepository = this.myRepository;
        newFactory.myField = field;
        return newFactory;
    }

    @Override
    public void setClassRepository(ClassRepository rep) {
        if (this.myRepository != null) {
            throw new IllegalStateException("A class repository has already been set for this object.");
        }
        if (rep == null) {
            throw new IllegalArgumentException("Non-null class repository is required.");
        }
        this.myRepository = rep;
    }

    @Override
    public Object parseValueString(String aString) {
        ERETime time;
        try {
            time = ERETimeFactory.parseTimeString(aString);
        }
        catch (IllegalArgumentException ex) {
            time = new LazyEvaluatedERETime(aString);
        }
        return time;
    }

    @Override
    public Object createDefaultInstance() {
        return ERETimeFactory.now();
    }

    @Override
    public String makeValueString(Object anObject) {
        String ret;
        if (anObject instanceof LazyEvaluatedERETime) {
            LazyEvaluatedERETime theLazyObj = (LazyEvaluatedERETime)anObject;
            ret = theLazyObj.getExpressionString();
        } else if (anObject instanceof ERETime) {
            String timeStr = DateUtil.formatISODateTime(((ERETime)anObject).asDate(), true);
            ret = timeStr + "F";
        } else {
            throw new IllegalArgumentException("Unknown object type: " + anObject);
        }
        return ret;
    }

    @Override
    public String makeDisplayString(Object anObject) {
        String result;
        if (anObject instanceof LazyEvaluatedERETime) {
            assert (this.myRepository != null) : "Need a class repository at this point in LazyEvaluatedERETimeClassFactory.";
            LazyEvaluatedERETime theLazyObj = (LazyEvaluatedERETime)anObject;
            String str = theLazyObj.getExpressionString();
            ExpressionParser parser = new ExpressionParser(new DefaultExpressionParserOptions(), new DefaultExpressionParserHandler(this.myRepository, null));
            try {
                Expression expr = parser.parse(str);
                result = ResolvingInfixExpressionFormatter.format(expr, this.createDataSet(this.myRepository), ResolvingInfixExpressionFormatter.ResolutionLevel.NONE);
            }
            catch (Exception ex) {
                result = "<Error in expression: " + ex.getMessage() + ">";
            }
        } else if (anObject instanceof ERETime) {
            ERETime time = (ERETime)anObject;
            result = ERETimeUtil.isBoundaryDate(time) ? (this.myField != null ? ERETimeUtil.getDisplayableStringForERETimeConstant(time, this.myField) : time.toString()) : DateUtil.format(time.asDate(), DateUtil.DATE_TEXT_FORMAT[2]);
        } else {
            throw new IllegalArgumentException("Unknown object type: " + anObject);
        }
        return result;
    }

    private DataSet createDataSet(ClassRepository repository) {
        DataSetFactory factory = repository.getDataSetFactory();
        return factory.createDataSet();
    }
}

