/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import ericsson.ere.datatype.interfaces.UnsignedInt;
import java.math.BigInteger;

public final class UnsignedLong
extends Number {
    public static BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    public static BigInteger MIN_VALUE = BigInteger.ZERO;
    private static BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static UnsignedLong ZERO = new UnsignedLong(MIN_VALUE);
    public static UnsignedLong MAX = new UnsignedLong(MAX_VALUE);
    private final BigInteger myValue;

    public UnsignedLong(long value) {
        BigInteger val = value < 0L ? MAX_VALUE.add(BigInteger.valueOf(value)).add(BigInteger.ONE) : BigInteger.valueOf(value);
        this.myValue = val;
    }

    public UnsignedLong(BigInteger value) {
        this.checkValue(value);
        this.myValue = value;
    }

    public UnsignedLong(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null string not permitted.");
        }
        BigInteger value = new BigInteger(string);
        this.checkValue(value);
        this.myValue = value;
    }

    public BigInteger bigIntegerValue() {
        return this.myValue;
    }

    @Override
    public double doubleValue() {
        return this.myValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.myValue.floatValue();
    }

    @Override
    public int intValue() {
        return this.myValue.intValue();
    }

    @Override
    public long longValue() {
        return this.myValue.longValue();
    }

    public String toString() {
        return this.myValue.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UnsignedInt) {
            return this.equalsUnsInt((UnsignedInt)obj);
        }
        if (obj instanceof UnsignedLong) {
            return this.myValue.equals(((UnsignedLong)obj).myValue);
        }
        return false;
    }

    private boolean equalsUnsInt(UnsignedInt other) {
        long lv = other.longValue();
        if (this.myValue.compareTo(LONG_MAX_VALUE) > 0) {
            return false;
        }
        return this.myValue.longValue() == lv;
    }

    public static UnsignedLong valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null string not permitted.");
        }
        BigInteger big = new BigInteger(string);
        if (big.equals(BigInteger.ZERO)) {
            return ZERO;
        }
        if (big.equals(MAX_VALUE)) {
            return MAX;
        }
        return new UnsignedLong(big);
    }

    public static UnsignedLong valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        return new UnsignedLong(value);
    }

    private void checkValue(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not permitted.");
        }
        if (value.compareTo(MIN_VALUE) < 0 || value.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException("UnsignedLong value out of range.");
        }
    }
}

