/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import ericsson.ere.management.DateUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;

public class Time
implements Comparable<Time>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6507550873917959625L;
    private Calendar myCalendar;

    public Time() {
        this.myCalendar = Calendar.getInstance();
    }

    public Time(String iso_string) {
        if (iso_string == null || iso_string.equals("")) {
            this.myCalendar = Calendar.getInstance();
        } else {
            try {
                this.myCalendar = DateUtil.stringToCalendar(iso_string);
            }
            catch (ParseException x) {
                throw new IllegalArgumentException("Failed parsing string to Time: " + iso_string);
            }
        }
    }

    public Time(Calendar calendar) {
        this.myCalendar = calendar;
    }

    public Time clone() {
        try {
            Time clone = (Time)super.clone();
            clone.myCalendar = (Calendar)this.myCalendar.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getString() {
        return DateUtil.format(this.myCalendar);
    }

    public String toString() {
        return this.getString();
    }

    public Calendar getCalendar() {
        return this.myCalendar;
    }

    public static Time valueOf(String aValue) {
        return new Time(aValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myCalendar == null ? 0 : this.myCalendar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time other = (Time)obj;
        return !(this.myCalendar == null ? other.myCalendar != null : !this.myCalendar.equals(other.myCalendar));
    }

    @Override
    public int compareTo(Time o) {
        return this.myCalendar.compareTo(o.myCalendar);
    }
}

