/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import java.io.Serializable;
import java.util.Arrays;

public class BcdString
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6448988900766797943L;
    private final byte[] myByteArray;
    private static boolean mySwap = false;

    public BcdString(byte[] byteArray) {
        this.myByteArray = byteArray != null ? byteArray : new byte[0];
    }

    public BcdString(String str) {
        if (str == null || str.length() == 0) {
            this.myByteArray = new byte[0];
        } else {
            try {
                BcdString tmp = BcdString.valueOf(str);
                this.myByteArray = tmp.myByteArray;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error for " + str + "Message : " + e.getMessage(), e);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        byte[] newArray = new byte[this.myByteArray.length];
        System.arraycopy(this.myByteArray, 0, newArray, 0, newArray.length);
        return new BcdString(newArray);
    }

    public byte[] getData() {
        return this.myByteArray;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.myByteArray);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BcdString other = (BcdString)obj;
        return Arrays.equals(this.myByteArray, other.myByteArray);
    }

    public String toString() {
        if (this.myByteArray == null) {
            return "";
        }
        char[] num = new char[this.myByteArray.length * 2];
        int cpos = this.myByteArray.length * 2;
        for (int n = this.myByteArray.length - 1; n >= 0; --n) {
            char lower;
            char upper;
            int oneByte = this.myByteArray[n] & 0xFF;
            if (oneByte == 255) continue;
            if (mySwap) {
                upper = (char)(oneByte & 0xF);
                lower = (char)(oneByte >>> 4);
            } else {
                lower = (char)(oneByte & 0xF);
                upper = (char)(oneByte >>> 4);
            }
            if (lower <= '\t') {
                num[--cpos] = (char)(lower + 48);
            } else if (lower < '\u000f') {
                num[--cpos] = (char)(lower + 55);
            }
            if (upper <= '\t') {
                num[--cpos] = (char)(upper + 48);
                continue;
            }
            if (upper >= '\u000f') continue;
            num[--cpos] = (char)(upper + 55);
        }
        String result = new String(num, cpos, this.myByteArray.length * 2 - cpos);
        return result;
    }

    public static BcdString valueOf(String aString) throws Exception {
        int index = 0;
        if (aString.length() == 0) {
            return new BcdString("");
        }
        byte[] byteArray = aString.length() % 2 == 0 ? new byte[aString.length() / 2] : new byte[aString.length() / 2 + 1];
        if (aString.equals("")) {
            return new BcdString("");
        }
        if (aString.startsWith("0x")) {
            index = 2;
        }
        while (index < aString.length()) {
            char characterDigit = aString.charAt(index);
            int value = Character.digit(characterDigit, 16);
            if (value == -1) {
                throw new Exception("Illegal character for BcdString " + characterDigit + ", only '0'-'9' 'A'-'F' allowed ");
            }
            byte firstByte = (byte)(value & 0xF);
            if (++index < aString.length()) {
                characterDigit = aString.charAt(index);
                value = (byte)Character.digit(characterDigit, 16);
            } else {
                value = 15;
            }
            if (value == -1) {
                throw new Exception("Illegal character for BcdString " + characterDigit + ", only '0'-'9' 'A'-'F' allowed ");
            }
            byte secondByte = (byte)(value & 0xF);
            if (++index % 2 != 0) continue;
            if (mySwap) {
                byteArray[index / 2 - 1] = (byte)(secondByte << 4);
                byteArray[index / 2 - 1] = (byte)(byteArray[index / 2 - 1] + firstByte);
                continue;
            }
            byteArray[index / 2 - 1] = (byte)(firstByte << 4);
            byteArray[index / 2 - 1] = (byte)(byteArray[index / 2 - 1] + secondByte);
        }
        return new BcdString(byteArray);
    }
}

