/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.string;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.condition.string.CharacterTree;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.conditions.string.OctetStringList.class)
public class OctetStringList
extends AbstractCondition {
    static String TAG_MODE = "Mode";
    private boolean iAmTrueIfInList = true;
    private CharacterTree myStrings;
    private boolean iAmAscii = true;

    @Override
    public boolean needsFieldToBeSet() {
        return true;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.setKey(fieldName);
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String theStrings = "";
        String mode = "Ascii";
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().equals("String") && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    theStrings = value.item(bb).getNodeValue();
                }
                if (!children.item(aa).getNodeName().equals(TAG_MODE) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                mode = value.item(bb).getNodeValue();
            }
        }
        if (mode.equals("Hex")) {
            this.iAmAscii = false;
            StringTokenizer next = new StringTokenizer(theStrings, ",\t\n\r\u0000", true);
            String newStrings = "";
            while (next.hasMoreTokens()) {
                String token = next.nextToken();
                if (token.equals(",") || token.equals("\t") || token.equals("\n") || token.equals("\r") || token.equals("\u0000")) {
                    newStrings = newStrings + token;
                    continue;
                }
                OctetString oStr = OctetString.valueOf(token);
                newStrings = newStrings + oStr.toAscii();
            }
            this.myStrings = new CharacterTree(newStrings);
        } else {
            this.iAmAscii = true;
            this.myStrings = new CharacterTree(theStrings);
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.iAmAscii ? 1231 : 1237);
        result = 31 * result + (this.iAmTrueIfInList ? 1231 : 1237);
        result = 31 * result + (this.myStrings == null ? 0 : this.myStrings.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetStringList other = (OctetStringList)obj;
        if (this.iAmAscii != other.iAmAscii) {
            return false;
        }
        if (this.iAmTrueIfInList != other.iAmTrueIfInList) {
            return false;
        }
        return !(this.myStrings == null ? other.myStrings != null : !this.myStrings.equals(other.myStrings));
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        OctetString value = (OctetString)theData.getValueObject(this.key);
        String stringToCheck = value.toAscii();
        boolean result = false;
        String stringToDisplay = stringToCheck;
        if (!this.iAmAscii) {
            stringToDisplay = value.toString();
        }
        if (this.iAmTrueIfInList) {
            result = this.myStrings.checkString(stringToCheck);
        } else {
            boolean bl = result = !this.myStrings.checkString(stringToCheck);
        }
        if (theData.useTrace()) {
            theData.getTrace().println("\tOctetStringList.test " + stringToDisplay + " => " + (result ? "TRUE" : "FALSE"));
        }
        return result;
    }
}

