/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.string;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.condition.string.OctetStringCondition;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.OctetStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OctetStringConditionProfile
extends AbstractConditionProfile {
    private static String LABEL_COMPARATION = "Comparison";
    private static String LABEL_TEXT = "Text";
    private String[] myComparationChoices = new String[]{"Begins with", "Ends with", "Contains", "Exact match"};

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new DropDownVariable(LABEL_COMPARATION, 0, (Object[])this.myComparationChoices));
        l.add(new OctetStringVariable(LABEL_TEXT, OctetString.valueOf("")));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String comp = "0";
        String text = "";
        String modeValue = "Ascii";
        NodeList children = iterator.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            NodeList value;
            int j;
            if (children.item(i).getNodeType() != 1) continue;
            String k = children.item(i).getNodeName();
            if (k.equalsIgnoreCase(OctetStringCondition.TAG_COMPARATION) && (j = 0) < (value = children.item(i).getChildNodes()).getLength()) {
                comp = value.item(j).getNodeValue();
            }
            if (k.equalsIgnoreCase(OctetStringCondition.TAG_TEXT) && (j = 0) < (value = children.item(i).getChildNodes()).getLength()) {
                text = value.item(j).getNodeValue();
            }
            if (!k.equalsIgnoreCase(OctetStringCondition.TAG_MODE) || (j = 0) >= (value = children.item(i).getChildNodes()).getLength()) continue;
            modeValue = value.item(j).getNodeValue();
        }
        l.add(new DropDownVariable(LABEL_COMPARATION, (Object)comp, 1, this.myComparationChoices));
        int comboBoxIndex = 0;
        comboBoxIndex = modeValue.equalsIgnoreCase("Hex") ? 0 : 1;
        OctetStringVariable textVar = new OctetStringVariable(LABEL_TEXT, text, comboBoxIndex);
        l.add(textVar);
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String type = "Hex";
        Variable var = VarListUtil.getVariableForName(variables, LABEL_TEXT);
        OctetStringVariable octVar = (OctetStringVariable)var;
        if (!octVar.getMode()) {
            type = "Ascii";
        }
        String text = octVar.getValueString();
        out.println("<" + OctetStringCondition.TAG_TEXT + ">" + text + "</" + OctetStringCondition.TAG_TEXT + ">");
        out.println("<" + OctetStringCondition.TAG_MODE + ">" + type + "</" + OctetStringCondition.TAG_MODE + ">");
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        out.println("<" + OctetStringCondition.TAG_COMPARATION + ">" + comp + "</" + OctetStringCondition.TAG_COMPARATION + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, LABEL_TEXT);
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        comp = comp.equals("-1") ? "Invalid" : this.myComparationChoices[Integer.valueOf(comp)].toLowerCase();
        String info = "<b>" + this.getDescription(variables) + "</b> (" + comp + " " + text + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

