/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.numberList;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.vareditor.documents.NumberListDocument;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NumberListProfile
extends AbstractConditionProfile {
    static String LABEL_NUMBER = "Numbers";
    static char[] allowedValues = new char[]{',', '\t', '\n', '\r', '\u0000', '-'};

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String number = VarListUtil.getValueStringForName(variables, LABEL_NUMBER);
        out.println("<Number>" + number + "</" + "Number" + ">");
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String defaultString = "";
        NumberListDocument doc = new NumberListDocument(allowedValues, true);
        l.add(new MultilineStringVariable(LABEL_NUMBER, defaultString, doc));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String number = "";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            String k;
            if (children.item(aa).getNodeType() != 1 || !(k = children.item(aa).getNodeName()).equals("Number") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            number = value.item(bb).getNodeValue();
        }
        NumberListDocument doc = new NumberListDocument(allowedValues, true);
        l.add(new MultilineStringVariable(LABEL_NUMBER, number, doc));
        return l;
    }
}

