/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.number;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.condition.number.UnsignedIntCondition;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.UnsignedInt8Variable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnsignedInt8ConditionProfile
extends AbstractConditionProfile {
    private static String LBL_VALUE = "Value";
    private static String LBL_OPERATOR = "Operator";
    private static final String[] numericOperatorArr = new String[]{"=", ">", "<", ">=", "<="};

    private String operatorToToken(String operator) {
        for (int i = 0; i < numericOperatorArr.length; ++i) {
            if (!numericOperatorArr[i].equals(operator)) continue;
            return UnsignedIntCondition.numericOperatorArr[i];
        }
        return operator;
    }

    private String tokenToOperator(String token) {
        for (int i = 0; i < UnsignedIntCondition.numericOperatorArr.length; ++i) {
            if (!UnsignedIntCondition.numericOperatorArr[i].equals(token)) continue;
            return numericOperatorArr[i];
        }
        return token;
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new DropDownVariable(LBL_OPERATOR, (Object)numericOperatorArr[0], (Object[])numericOperatorArr));
        l.add(new UnsignedInt8Variable(LBL_VALUE, new UnsignedInt8(0)));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String tagName = "LongValue";
        String operator = numericOperatorArr[0];
        String valueStr = "0";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            int bb;
            NodeList value;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase(tagName = this.getTagName(k))) {
                value = children.item(aa).getChildNodes();
                for (bb = 0; bb < value.getLength(); ++bb) {
                    valueStr = value.item(bb).getNodeValue();
                }
                continue;
            }
            if (!k.equalsIgnoreCase("Operator")) continue;
            value = children.item(aa).getChildNodes();
            for (bb = 0; bb < value.getLength(); ++bb) {
                String token = value.item(bb).getNodeValue();
                operator = this.tokenToOperator(token);
            }
        }
        l.add(new DropDownVariable(LBL_OPERATOR, (Object)operator, (Object[])numericOperatorArr));
        l.add(new UnsignedInt8Variable(LBL_VALUE, valueStr));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String operator = VarListUtil.getValueStringForName(variables, LBL_OPERATOR);
        String value = VarListUtil.getValueStringForName(variables, LBL_VALUE);
        String token = this.operatorToToken(operator);
        out.println("<Operator>" + token + "</" + "Operator" + ">");
        out.println("<LongValue>" + value + "</" + "LongValue" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String data = VarListUtil.getValueStringForName(variables, LBL_OPERATOR) + " ";
        data = data + VarListUtil.getValueStringForName(variables, LBL_VALUE);
        String info = "<b>" + this.getDescription(variables) + "</b> (" + GuiUtil.replaceSubString(data, "<", "&lt;") + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    private String getTagName(String fieldName) {
        String tagName = "LongValue";
        return tagName;
    }
}

