/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.logic;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.conditions.logic.CompoundBooleanCondition.class)
public class CompoundBooleanCondition
extends AbstractCondition {
    public static final String OP_AND = "AND";
    public static final String OP_OR = "OR";
    public static final String OP_NOT = "NOT";
    private List<Object> myConditions;
    private String myOperation;

    public CompoundBooleanCondition() {
    }

    public CompoundBooleanCondition(String operation, List<Object> conditions) {
        this.myOperation = operation;
        this.myConditions = conditions;
        int len = conditions.size();
        if (OP_NOT.equals(operation) && len != 1) {
            throw new IllegalArgumentException("Boolean NOT operation requires single argument");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("No conditions given");
        }
        if (!(OP_AND.equals(operation) || OP_OR.equals(operation) || OP_NOT.equals(operation))) {
            throw new IllegalArgumentException("Unrecognized boolean operator: " + operation);
        }
    }

    public void addCondition(Condition cond) {
        if (this.myOperation.equals(OP_NOT) && this.myConditions.size() == 1) {
            throw new IllegalArgumentException("CompoundBooleanCondition: Boolean NOT operation requires single argument");
        }
        this.myConditions.add(cond);
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        return (DAGNode)this.myConditions.get(index);
    }

    @Override
    public int getChildCount() {
        return this.myConditions.size();
    }

    @Override
    public void insertChildAt(int index, DAGNode node) {
        this.myConditions.add(index, node);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) {
        this.myConditions.add(index, node);
    }

    @Override
    protected void removeChild(DAGNode node) {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public void add(Condition child) throws Exception {
        this.addCondition(child);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int i = -1;
        if (this.myConditions != null) {
            i = DAGUtil.indexOf(child, this.myConditions);
        }
        if (i < 0) {
            throw new IllegalArgumentException("Child not found: " + child);
        }
        this.myConditions.set(i, replacement);
    }

    public void printNode(Node node, int ident) {
        String name = node.getNodeName();
        String value = node.getNodeValue();
        if (name == null) {
            name = "nul";
        }
        if (value == null) {
            value = "nul";
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.printNode(children.item(i), ident + 1);
        }
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String operator = null;
        NodeList children = iterator.getChildNodes();
        if (children.getLength() > 0) {
            this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        }
        int ncond = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().toLowerCase().equals("operation")) {
                if (!child.hasChildNodes()) continue;
                operator = child.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (!child.getNodeName().toLowerCase().equals("condition")) continue;
            ++ncond;
        }
        if (!(OP_OR.equals(operator) || OP_AND.equals(operator) || OP_NOT.equals(operator))) {
            throw new Exception("Erroneous operator: " + operator);
        }
        this.myOperation = operator;
        this.myConditions = new ArrayList<Object>(ncond);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myConditions == null ? 0 : this.myConditions.hashCode());
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundBooleanCondition other = (CompoundBooleanCondition)obj;
        if (this.myConditions == null ? other.myConditions != null : !this.myConditions.equals(other.myConditions)) {
            return false;
        }
        return !(this.myOperation == null ? other.myOperation != null : !this.myOperation.equals(other.myOperation));
    }

    @Override
    public boolean needsFieldToBeSet() {
        return false;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.setKey(fieldName);
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        boolean res = false;
        if (this.myOperation.equals(OP_AND)) {
            res = this.testAND(theData, theCost, theTime);
        } else if (this.myOperation.equals(OP_OR)) {
            res = this.testOR(theData, theCost, theTime);
        } else if (this.myOperation.equals(OP_NOT)) {
            res = this.testNOT(theData, theCost, theTime);
        } else {
            throw new Exception("Unknown operation in TCCompoundBooleanCondition::test()");
        }
        return res;
    }

    private boolean testAND(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        int ncond = this.myConditions.size();
        boolean useTrace = theData.useTrace();
        if (useTrace) {
            String type = this.getTypename();
            String id = this.getNodeId();
            String msgString = "\tCondition : ";
            if (!type.equals(id)) {
                type = type + " [" + id + "]";
            }
            msgString = msgString + type + " " + this.myOperation + "(#cond: " + ncond + ")";
            theData.getTrace().println(msgString);
        }
        long savedCurrentMaxDuration = theData.currentMaxDuration;
        long encounteredMinOfCurrentMaxDuration = theData.currentMaxDuration;
        boolean match = true;
        StringBuffer boolResult = null;
        if (useTrace) {
            boolResult = new StringBuffer(ncond);
        }
        for (int i = 0; i < ncond; ++i) {
            theData.currentMaxDuration = savedCurrentMaxDuration;
            Condition tc = (Condition)this.myConditions.get(i);
            boolean condRes = tc.test(theData, theCost, theTime);
            if (useTrace) {
                if (condRes) {
                    boolResult.append('T');
                } else {
                    boolResult.append('F');
                }
            }
            if (condRes && encounteredMinOfCurrentMaxDuration > theData.currentMaxDuration) {
                encounteredMinOfCurrentMaxDuration = theData.currentMaxDuration;
            }
            if (!(match &= condRes)) break;
        }
        theData.currentMaxDuration = savedCurrentMaxDuration;
        if (match) {
            theData.setCurrentMaxDuration(encounteredMinOfCurrentMaxDuration);
            if (useTrace) {
                theData.getTrace().println("\t" + this.myOperation + "(" + boolResult.toString() + ") => TRUE ");
            }
        } else if (useTrace) {
            theData.getTrace().println("\t" + this.myOperation + "(" + boolResult.toString() + ") => FALSE ");
        }
        return match;
    }

    private boolean testOR(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        int ncond = this.myConditions.size();
        boolean useTrace = theData.useTrace();
        if (useTrace) {
            String type = this.getTypename();
            String id = this.getNodeId();
            String msgString = "\tCondition : ";
            if (!type.equals(id)) {
                type = type + " [" + id + "]";
            }
            msgString = msgString + type + " " + this.myOperation + "(#cond: " + ncond + ")";
            theData.getTrace().println(msgString);
        }
        long savedCurrentMaxDuration = theData.currentMaxDuration;
        long encounteredMaxOfCurrentMaxDuration = 0L;
        boolean match = false;
        StringBuffer boolResult = null;
        if (useTrace) {
            boolResult = new StringBuffer(ncond);
        }
        for (int i = 0; i < ncond; ++i) {
            theData.currentMaxDuration = savedCurrentMaxDuration;
            Condition tc = (Condition)this.myConditions.get(i);
            boolean condRes = tc.test(theData, theCost, theTime);
            if (useTrace) {
                if (condRes) {
                    boolResult.append('T');
                } else {
                    boolResult.append('F');
                }
            }
            if (condRes && encounteredMaxOfCurrentMaxDuration < theData.currentMaxDuration) {
                encounteredMaxOfCurrentMaxDuration = theData.currentMaxDuration;
            }
            match |= condRes;
        }
        theData.currentMaxDuration = savedCurrentMaxDuration;
        if (match) {
            theData.setCurrentMaxDuration(encounteredMaxOfCurrentMaxDuration);
            if (useTrace) {
                theData.getTrace().println("\t" + this.myOperation + "(" + boolResult.toString() + ") => TRUE ");
            }
        } else if (useTrace) {
            theData.getTrace().println("\t" + this.myOperation + "(" + boolResult.toString() + ") => FALSE ");
        }
        return match;
    }

    private boolean testNOT(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        int ncond = this.myConditions.size();
        if (theData.useTrace()) {
            String type = this.getTypename();
            String id = this.getNodeId();
            String msgString = "\tCondition : ";
            if (!type.equals(id)) {
                type = type + " [" + id + "]";
            }
            msgString = msgString + type + " " + this.myOperation + "(#cond: " + ncond + ")";
            theData.getTrace().println(msgString);
        }
        long savedCurrentMaxDuration = theData.currentMaxDuration;
        Condition tc = (Condition)this.myConditions.get(0);
        boolean condRes = tc.test(theData, theCost, theTime);
        StringBuffer boolResult = new StringBuffer(1);
        if (condRes) {
            boolResult.append('T');
        } else {
            boolResult.append('F');
        }
        boolean match = !condRes;
        theData.currentMaxDuration = savedCurrentMaxDuration;
        if (match) {
            theData.setCurrentMaxDuration(tc.getConditionUnsatisfiedDuration(theData));
            if (theData.useTrace()) {
                theData.getTrace().println("\t" + this.myOperation + "(" + boolResult.toString() + ") => TRUE ");
            }
        } else if (theData.useTrace()) {
            theData.getTrace().println("\t" + this.myOperation + "(" + boolResult.toString() + ") => FALSE ");
        }
        return match;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public long getConditionSatisfiedDuration(RatingData theData) {
        long res;
        int ncond = this.myConditions.size();
        if (this.myOperation.equals(OP_AND)) {
            res = Long.MAX_VALUE;
            for (int i = 0; i < ncond; ++i) {
                Condition tc = (Condition)this.myConditions.get(i);
                long current = tc.getConditionSatisfiedDuration(theData);
                if (current >= res) continue;
                res = current;
            }
        } else if (this.myOperation.equals(OP_OR)) {
            res = 0L;
            for (int i = 0; i < ncond; ++i) {
                Condition tc = (Condition)this.myConditions.get(i);
                long current = tc.getConditionSatisfiedDuration(theData);
                if (current <= res) continue;
                res = current;
            }
        } else if (this.myOperation.equals(OP_NOT)) {
            Condition tc = (Condition)this.myConditions.get(0);
            res = tc.getConditionUnsatisfiedDuration(theData);
        } else {
            throw new Error("Unknown operation in TCCompoundBooleanCondition::getConditionSatisfiedDuration()");
        }
        return res;
    }

    @Override
    public long getConditionUnsatisfiedDuration(RatingData theData) {
        long res;
        int ncond = this.myConditions.size();
        if (this.myOperation.equals(OP_AND)) {
            res = 0L;
            for (int i = 0; i < ncond; ++i) {
                Condition tc = (Condition)this.myConditions.get(i);
                long current = tc.getConditionUnsatisfiedDuration(theData);
                if (current <= res) continue;
                res = current;
            }
        } else if (this.myOperation.equals(OP_OR)) {
            res = Long.MAX_VALUE;
            for (int i = 0; i < ncond; ++i) {
                Condition tc = (Condition)this.myConditions.get(i);
                long current = tc.getConditionUnsatisfiedDuration(theData);
                if (current >= res) continue;
                res = current;
            }
        } else if (this.myOperation.equals(OP_NOT)) {
            Condition tc = (Condition)this.myConditions.get(0);
            res = tc.getConditionSatisfiedDuration(theData);
        } else {
            throw new Error("Unknown operation in TCCompoundBooleanCondition::getConditionUnsatisfiedDuration()");
        }
        return res;
    }
}

