/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.ipaddress;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.condition.ipaddress.IpAddress;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.documents.IpAddressMaskDocument;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IpAddressProfile
extends AbstractConditionProfile {
    private static final String LBL_MASK = "Mask";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(new StringVariable(LBL_MASK, "0.0.0.0", new IpAddressMaskDocument()));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        String maskString = "0.0.0.0";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            String k;
            if (children.item(aa).getNodeType() != 1 || !(k = children.item(aa).getNodeName()).equalsIgnoreCase(IpAddress.TAG_MASK) || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            maskString = value.item(bb).getNodeValue();
        }
        l.add(new StringVariable(LBL_MASK, maskString, new IpAddressMaskDocument()));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String mask = VarListUtil.getValueStringForName(variables, LBL_MASK);
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<");
        out.print(IpAddress.TAG_MASK);
        out.print(">");
        out.print(mask);
        out.print("</");
        out.print(IpAddress.TAG_MASK);
        out.println(">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String mask = VarListUtil.getValueStringForName(variables, LBL_MASK);
        String info = "<b>" + this.getDescription(variables) + "</b>";
        info = info + " (" + mask + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

