/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.bonus;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccumulatedBonusProfile
extends AbstractConditionProfile {
    String TAG_ACCUMULATED_BONUS = "Accumulated Bonus";
    public String TAG_MAX_VALUE = "Counter max value";
    public String TAG_MIN_VALUE = "Counter min value";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        l.add(new LongVariable(this.TAG_MAX_VALUE, Long.MAX_VALUE));
        l.add(new LongVariable(this.TAG_MIN_VALUE, Long.MIN_VALUE));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        String max = String.valueOf(Long.MAX_VALUE);
        String min = String.valueOf(Long.MIN_VALUE);
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            String valueStr;
            int bb;
            NodeList value;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("CounterMaxValue")) {
                value = children.item(aa).getChildNodes();
                for (bb = 0; bb < value.getLength(); ++bb) {
                    max = valueStr = value.item(bb).getNodeValue();
                }
                continue;
            }
            if (!k.equalsIgnoreCase("CounterMinValue")) continue;
            value = children.item(aa).getChildNodes();
            for (bb = 0; bb < value.getLength(); ++bb) {
                min = valueStr = value.item(bb).getNodeValue();
            }
        }
        l.add(new LongVariable(this.TAG_MAX_VALUE, max));
        l.add(new LongVariable(this.TAG_MIN_VALUE, min));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String maxValue = VarListUtil.getValueStringForName(variables, this.TAG_MAX_VALUE);
        String minValue = VarListUtil.getValueStringForName(variables, this.TAG_MIN_VALUE);
        for (i = 0; i < indentLevel; ++i) {
            out.print(indentMarker);
        }
        out.println("<CounterMaxValue>" + maxValue + "</" + "CounterMaxValue" + ">");
        for (i = 0; i < indentLevel; ++i) {
            out.print(indentMarker);
        }
        out.println("<CounterMinValue>" + minValue + "</" + "CounterMinValue" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String maxValue = VarListUtil.getValueStringForName(variables, this.TAG_MAX_VALUE);
        String minValue = VarListUtil.getValueStringForName(variables, this.TAG_MIN_VALUE);
        String info = "<b>" + this.getDescription(variables) + "</b> (Counter max value=" + maxValue + " Counter min value=" + minValue + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

