/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RatingStructureProfile
implements ClassProfile {
    public static String LBL_ID = "Id";
    public static String LBL_NAME = "Name";
    public static String LBL_COMMENT = "Comment";
    private static String TAG_COMMENT = "Comment";

    @Override
    public boolean needsRepository() {
        return false;
    }

    @Override
    public void setClassRepository(ClassRepository aRepository) {
    }

    @Override
    public void setTariffStructureNode(DAGNode tariffStructureNode) {
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(6);
        BaseVariable var = new StringVariable("Service Id", "");
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Created", DateAndTimeVariable.Content.DATE_TIME);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Saved", DateAndTimeVariable.Content.DATE_TIME);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NamedNodeMap attributes = iterator.getAttributes();
        NodeList children = iterator.getChildNodes();
        ArrayList<Variable> l = new ArrayList<Variable>(6);
        String serviceId = "";
        String created = "";
        String saved = "";
        Node n = attributes.getNamedItem("ServiceId");
        if (n != null) {
            serviceId = n.getNodeValue();
        }
        for (int aa = 0; aa < children.getLength(); ++aa) {
            n = children.item(aa);
            if (n.getNodeType() != 1) continue;
            String k = n.getNodeName();
            if ("Created".equals(k)) {
                created = n.getAttributes().getNamedItem("Date").getNodeValue();
            }
            if (!"Saved".equals(k)) continue;
            saved = n.getAttributes().getNamedItem("Date").getNodeValue();
        }
        BaseVariable var = new StringVariable("Service Id", serviceId);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Created", DateAndTimeVariable.Content.DATE_TIME, created);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Saved", DateAndTimeVariable.Content.DATE_TIME, saved);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        return l;
    }

    @Override
    public void printPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        for (int i = 0; i < indentLevel; ++i) {
            out.print(indentMarker);
        }
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String id = VarListUtil.getValueStringForName(variables, "Id");
        String service = VarListUtil.getValueStringForName(variables, "Service Id");
        out.print("<TariffStructure");
        out.print(" Name=\"" + XMLUtil.escape(name) + "\"");
        out.print(" type=\"" + XMLUtil.escape("TariffStructure") + "\"");
        out.print(" id=\"" + XMLUtil.escape(id) + "\"");
        out.print(" ServiceId=\"" + XMLUtil.escape(service) + "\">");
    }

    @Override
    public void printParameters(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String comment;
        String created = VarListUtil.getTimeValueForName(variables, "Created").toString();
        String saved = VarListUtil.getTimeValueForName(variables, "Saved").toString();
        boolean commentIsUsed = RmaDefs.getInstance().useCommentCondition();
        out.println("");
        if (commentIsUsed && (comment = VarListUtil.getValueStringForName(variables, LBL_COMMENT)).length() > 0) {
            for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                out.print(indentMarker);
            }
            out.print("<");
            out.print(TAG_COMMENT);
            out.print(">");
            out.print(XMLUtil.escape(comment));
            out.print("</");
            out.print(TAG_COMMENT);
            out.println(">");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<Created Date=\"");
        out.print(created);
        out.println("\"/>");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<Saved Date=\"");
        out.print(saved);
        out.println("\"/>");
    }

    @Override
    public void printPostamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        out.println("</TariffStructure>");
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        if (variables == null) {
            return "";
        }
        String name = VarListUtil.getValueStringForName(variables, LBL_NAME);
        return name;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String service = VarListUtil.getValueStringForName(variables, "Service Id");
        String saved = VarListUtil.getTimeValueForName(variables, "Saved").toString();
        String info = "<b>" + this.getDescription(variables) + "</b>\nService: '" + service + "' - Saved: " + saved;
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public String getAdditionalInfo() {
        return null;
    }
}

