/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere;

import com.ericsson.ere.annotations.SupersededBy;
import com.ericsson.ere.selectiontree.structures.DefaultTreeStructure;
import ericsson.ere.RatingData;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.statement.NodeStatement;
import ericsson.ere.statement.Statement;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Deprecated
@SupersededBy(value=DefaultTreeStructure.class)
public class RatingStructure
extends AbstractDAGNode
implements TariffStructure,
TariffStructureNode,
XMLInitializable {
    private String myName;
    private String myNodeId = null;
    private NodeStatement myStatement = null;
    public ClassRepository repository = null;

    public RatingStructure(long theId, boolean theInEuroFlag, double theDefaultPrice, long theDefaultDurationInterval, double theDefaultFee, Statement theStatement, ClassRepository rep) {
        this.repository = rep;
        this.myStatement = (NodeStatement)theStatement;
    }

    public RatingStructure(ClassRepository rep) {
        this.repository = rep;
    }

    public RatingStructure() {
    }

    @Override
    public ClassRepository getClassRepository() {
        return this.repository;
    }

    @Override
    public void setClassRepository(ClassRepository rep) {
        this.repository = rep;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        NamedNodeMap attr = iterator.getAttributes();
        if (attr == null) {
            throw new IllegalArgumentException("Attributes not found in TariffStructure");
        }
        Node node = attr.getNamedItem("id");
        if (node != null) {
            this.myNodeId = node.getNodeValue();
        }
        if ((node = attr.getNamedItem("Name")) == null) {
            throw new IllegalArgumentException(EreDefs.getErrorString("error.noNameAttrInTariff"));
        }
        this.myName = node.getNodeValue();
        node = attr.getNamedItem("ServiceId");
        if (node == null) {
            throw new IllegalArgumentException(EreDefs.getErrorString("error.noServiceAttrInTariff"));
        }
        return this;
    }

    private void checkCreateStatement() {
        if (this.myStatement == null) {
            this.myStatement = new NodeStatement(this.myName, false, 100.0);
            if (this.myNodeId != null && !"".equals(this.myNodeId.trim())) {
                this.myStatement.setNodeId(this.myNodeId);
            }
        }
    }

    @Override
    public void add(Statement child) throws Exception {
        this.checkCreateStatement();
        this.myStatement.addChildStatement(child);
    }

    @Override
    public DAGNode getChildAt(int i) {
        this.checkCreateStatement();
        return this.myStatement.getChildAt(i);
    }

    @Override
    public int getChildCount() {
        this.checkCreateStatement();
        return this.myStatement.getChildCount();
    }

    @Override
    public void insertChildAt(int i, DAGNode n) {
        this.checkCreateStatement();
        this.myStatement.insertChildAt(i, n);
    }

    @Override
    public void insertLinkAt(int i, DAGNode n) {
        this.checkCreateStatement();
        this.myStatement.insertLinkAt(i, n);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        this.checkCreateStatement();
        this.myStatement.replace(child, replacement);
    }

    @Override
    protected void removeChild(DAGNode n) {
        throw new IllegalArgumentException(EreDefs.getErrorString("error.nodeNotRemoved"));
    }

    @Override
    protected void removeLink(DAGNode n) {
        throw new IllegalArgumentException(EreDefs.getErrorString("error.nodeNotRemoved"));
    }

    @Override
    public void rate(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        DoubleValue theAlreadyPaidCost = new DoubleValue(0.0);
        LongValue theAlreadyUsedTime = new LongValue(0L);
        DoubleValue theNewPeriodCost = new DoubleValue(0.0);
        LongValue theNewPeriodTime = new LongValue(0L);
        if (this.myStatement == null) {
            throw new Exception(EreDefs.getErrorString("error.noTariffWasTriggred"));
        }
        if (theData.accumulatedDuration > 0L && theData.maxDuration != -1L) {
            theData.initWorkingParameters(0L, theData.accumulatedDuration, theData.startTime, -1.0);
            this.myStatement.rate(theData, theAlreadyPaidCost, theAlreadyUsedTime);
            if (!theData.hasRated) {
                throw new Exception(EreDefs.getErrorString("error.noTariffWasTriggred"));
            }
            theAlreadyPaidCost.setValue(theData.totalCost);
            if (theData.useTrace()) {
                theData.getTrace().println("ALREADY PAID : COST " + theAlreadyPaidCost + " TIME " + theAlreadyUsedTime + " TOTAL COST " + theData.totalCost);
            }
        }
        if (theData.maxDuration > 0L) {
            theData.initWorkingParameters(theAlreadyUsedTime.value, theData.maxDuration - (theAlreadyUsedTime.value - theData.accumulatedDuration), theData.startTime + theAlreadyUsedTime.value, theData.maxCost);
            if (theData.currentMaxDuration > 0L) {
                this.myStatement.rate(theData, theNewPeriodCost, theNewPeriodTime);
                if (!theData.hasRated) {
                    throw new Exception(EreDefs.getErrorString("error.noTariffWasTriggred"));
                }
                theCost.setValue(theNewPeriodCost.value);
                theTime.setValue(theData.currentDuration - theData.accumulatedDuration);
            } else {
                theNewPeriodCost.setValue(0.0);
                theCost.setValue(0.0);
                theTime.setValue(theData.currentDuration - theData.accumulatedDuration);
            }
        } else if (theData.maxDuration == 0L) {
            theNewPeriodCost.setValue(0.0);
            theCost.setValue(0.0);
            theTime.setValue(0L);
        } else if (theData.maxDuration == -1L && theData.accumulatedDuration <= 0L) {
            if (theData.useTrace()) {
                theData.getTrace().println("\ttheData->input.maxDuration = " + theData.maxDuration + " theData->accumulatedDuration = " + theData.accumulatedDuration);
            }
            theData.initWorkingParameters(theAlreadyUsedTime.value, theData.maxDuration, theData.startTime, theData.maxCost);
            this.myStatement.rate(theData, theNewPeriodCost, theNewPeriodTime);
            if (!theData.hasRated) {
                throw new Exception(EreDefs.getErrorString("error.noTariffWasTriggred"));
            }
            theCost.setValue(theNewPeriodCost.value);
            theTime.setValue(theData.currentDuration - theData.accumulatedDuration);
        } else if (theData.maxDuration == -1L && theData.accumulatedDuration > 0L) {
            theData.initWorkingParameters(theAlreadyUsedTime.value, theData.accumulatedDuration, theData.startTime, theData.maxCost);
            this.myStatement.rate(theData, theNewPeriodCost, theNewPeriodTime);
            if (theData.hasRated) {
                throw new Exception(EreDefs.getErrorString("error.noTariffWasTriggred"));
            }
            theCost.setValue(theNewPeriodCost.value);
            theTime.setValue(theData.currentDuration - theData.accumulatedDuration);
        } else {
            throw new Exception(EreDefs.getErrorString("error.noTariffWasTriggred"));
        }
        if (theData.useTrace()) {
            theData.getTrace().println("NEW PERIOD : COST " + theCost + " TIME " + theTime + " TOTAL COST " + theData.totalCost);
        }
        theData.totalCost = theAlreadyPaidCost.value + theNewPeriodCost.value;
        if (theData.useTrace()) {
            theData.getTrace().println("THE REAL TOTAL COST " + theData.totalCost);
        }
    }

    @Override
    public int getNodeType() {
        return 0;
    }

    @Override
    public String getNodeId() {
        this.checkCreateStatement();
        return this.myStatement.getNodeId();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterTariffStructure(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveTariffStructure(this);
    }
}

