/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import com.ericsson.vareditor.document.DefaultLimitEvent;
import com.ericsson.vareditor.document.LimitListener;
import com.ericsson.vareditor.document.StatusHandlerLimitListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitingDocument
extends PlainDocument
implements FieldValidation {
    private Pattern myCharacterPattern;
    private Pattern myStringPattern;
    private boolean myIsInvalid = false;
    private boolean myLimitActive = true;
    private List<LimitListener> myLimitListeners = new ArrayList<LimitListener>();
    private StatusHandlerLimitListener myStandardLimitListener = new StatusHandlerLimitListener(new RMAStatusInterface());

    public LimitingDocument(Pattern characterPattern) {
        if (characterPattern == null) {
            throw new IllegalArgumentException("Null character acceptance pattern not permitted.");
        }
        this.myCharacterPattern = characterPattern;
        this.addLimitListener(this.myStandardLimitListener);
    }

    public LimitingDocument(Pattern characterPattern, Pattern stringPattern) {
        this(characterPattern);
        this.myStringPattern = stringPattern;
        try {
            this.testWholeText("");
        }
        catch (Rejection e) {
            this.myIsInvalid = true;
        }
    }

    @Override
    public void insertString(int offset, String insertText, AttributeSet arg2) throws BadLocationException {
        if (!this.myLimitActive) {
            super.insertString(offset, insertText, arg2);
            return;
        }
        try {
            this.testByCharacter(insertText);
        }
        catch (Rejection rt) {
            this.fireInsertRejectEvent(insertText, rt.getMessage());
            return;
        }
        String currText = this.getAllText();
        int currLength = currText.length();
        int insertLength = insertText.length();
        char[] newChars = new char[currLength + insertLength];
        currText.getChars(0, offset, newChars, 0);
        insertText.getChars(0, insertLength, newChars, offset);
        currText.getChars(offset, currLength, newChars, offset + insertLength);
        String newText = new String(newChars);
        this.testNewWholeText(newText);
        super.insertString(offset, insertText, arg2);
    }

    @Override
    public void remove(int offset, int removeLen) throws BadLocationException {
        if (!this.myLimitActive) {
            super.remove(offset, removeLen);
            return;
        }
        String currText = this.getAllText();
        int currLength = currText.length();
        char[] newChars = new char[currLength - removeLen];
        currText.getChars(0, offset, newChars, 0);
        currText.getChars(offset + removeLen, currLength, newChars, offset);
        String newText = new String(newChars);
        this.testNewWholeText(newText);
        super.remove(offset, removeLen);
    }

    protected final void testNewWholeText(String newText) {
        boolean valid = true;
        String reason = null;
        try {
            this.testWholeText(newText);
        }
        catch (Rejection rt) {
            valid = false;
            reason = rt.getMessage();
        }
        boolean stateChange = valid == this.myIsInvalid;
        this.myIsInvalid = !valid;
        this.notifyListeners(newText, reason, valid, stateChange);
    }

    protected void notifyListeners(String newText, String reason, boolean valid, boolean isStateChange) {
        if (isStateChange) {
            if (valid) {
                this.fireTextValidEvent(newText);
            } else {
                this.fireTextInvalidEvent(newText, reason);
            }
        }
    }

    protected void testWholeText(String text) throws Rejection {
        if (this.myStringPattern != null && !this.myStringPattern.matcher(text).matches()) {
            throw new Rejection("The text is invalid: " + text);
        }
    }

    protected void testByCharacter(String insertText) throws Rejection {
        String[] strings = this.myCharacterPattern.split(insertText);
        if (!insertText.isEmpty() && strings.length > 0) {
            throw new Rejection("The text contains invalid characters: " + insertText);
        }
    }

    public void addLimitListener(LimitListener listener) {
        this.myLimitListeners.add(listener);
        if (this.myIsInvalid) {
            listener.textInvalid(new DefaultLimitEvent(this, this.getAllText()));
        }
    }

    public void removeLimitListener(LimitListener listener) {
        this.myLimitListeners.remove(listener);
    }

    protected final String getAllText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected final void fireInsertRejectEvent(String text, String reason) {
        DefaultLimitEvent event = new DefaultLimitEvent(this, text, reason);
        for (LimitListener l : this.myLimitListeners) {
            l.insertionRejected(event);
        }
    }

    protected final void fireTextInvalidEvent(String text, String reason) {
        DefaultLimitEvent event = new DefaultLimitEvent(this, text, reason);
        for (LimitListener l : this.myLimitListeners) {
            l.textInvalid(event);
        }
    }

    protected final void fireTextValidEvent(String text) {
        DefaultLimitEvent event = new DefaultLimitEvent(this, text);
        for (LimitListener l : this.myLimitListeners) {
            l.textValid(event);
        }
    }

    protected void setActive(boolean active) {
        if (!this.myLimitActive && active) {
            this.testNewWholeText(this.getAllText());
        }
        this.myLimitActive = active;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.setActive(enable);
    }

    @Override
    public boolean isValid(String value) {
        try {
            this.testByCharacter(value);
            this.testWholeText(value);
        }
        catch (Rejection ex) {
            return false;
        }
        return true;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        if (statusHandler == null) {
            throw new IllegalArgumentException("Status handler cannot be null");
        }
        this.removeLimitListener(this.myStandardLimitListener);
        this.myStandardLimitListener = new StatusHandlerLimitListener(statusHandler);
        this.addLimitListener(this.myStandardLimitListener);
    }

    public static class Rejection
    extends Exception {
        public Rejection(String reason) {
            super(reason);
        }
    }
}

