/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.vareditor.document.LimitingDocument;
import com.ericsson.vareditor.document.TokenizingDocument;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class DigitListDocument
extends TokenizingDocument {
    private static final String PROTOTYPE_STRING = "0123456789abcdefABCDEF*#-";
    private static final Pattern CHARACTER_PATTERN = Pattern.compile("[0-9a-fA-F#\\*-]");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[0-9a-fA-F#\\*]+|([0-9]+-[0-9]+)");
    private static final Pattern DEFAULT_DELIMITER_PATTERN = Pattern.compile("[ ,]");

    public DigitListDocument() {
        this(DEFAULT_DELIMITER_PATTERN);
    }

    public DigitListDocument(Pattern delimiterPattern) {
        super(CHARACTER_PATTERN, TOKEN_PATTERN, delimiterPattern);
        if (!DigitListDocument.validateDelimiterPattern(delimiterPattern, PROTOTYPE_STRING)) {
            throw new IllegalArgumentException("The delimiter pattern contains illegal characters");
        }
    }

    @Override
    protected void testToken(String token) throws LimitingDocument.Rejection {
        String[] rangeValues;
        if (!token.isEmpty()) {
            super.testToken(token);
        }
        if ((rangeValues = token.split("-")).length == 2) {
            this.testRange(rangeValues[0], rangeValues[1]);
        }
    }

    protected void testRange(String startValueString, String endValueString) throws LimitingDocument.Rejection {
        BigInteger startValue = new BigInteger(startValueString);
        BigInteger endValue = new BigInteger(endValueString);
        if (startValue.compareTo(endValue) >= 0) {
            throw new LimitingDocument.Rejection("Invalid range in token: " + startValueString + "-" + endValueString);
        }
    }
}

