/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.vareditor.document.LimitingDocument;
import com.ericsson.vareditor.document.TokenizingDocument;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public abstract class AbstractNumbersDocument
extends TokenizingDocument {
    private static final String INTEGER_PROTOTYPE_STRING = "0123456789-";
    private static final String FLOAT_PROTOTYPE_STRING = ".0123456789-";
    private static final Pattern NUMBER_CHARS_WHOLE = Pattern.compile("[0-9-]");
    private static final Pattern NUMBER_CHARS_FLOAT = Pattern.compile("[\\.0-9-]");
    private boolean myAllowRange;

    protected AbstractNumbersDocument(Pattern delims, boolean allowRange, boolean allowFloatingPoint) {
        super(AbstractNumbersDocument.selectCharPattern(allowFloatingPoint), delims);
        if (!AbstractNumbersDocument.validateDelimiterPattern(delims, AbstractNumbersDocument.selectPrototypeString(allowFloatingPoint))) {
            throw new IllegalArgumentException("The delimiter pattern contains illegal characters");
        }
        this.myAllowRange = allowRange;
    }

    private static Pattern selectCharPattern(boolean allowFloatingPoint) {
        return allowFloatingPoint ? NUMBER_CHARS_FLOAT : NUMBER_CHARS_WHOLE;
    }

    private static String selectPrototypeString(boolean allowFloatingPoint) {
        return allowFloatingPoint ? FLOAT_PROTOTYPE_STRING : INTEGER_PROTOTYPE_STRING;
    }

    @Override
    protected final void testToken(String token) throws LimitingDocument.Rejection {
        if ("".equals(token)) {
            return;
        }
        String[] parts = token.split("(?<=\\d)-(?=[\\d-])");
        if (parts.length > 1) {
            if (!this.myAllowRange) {
                throw new LimitingDocument.Rejection("Number range is not allowed.");
            }
            if (parts.length > 2) {
                throw new LimitingDocument.Rejection("Not a valid range in token: " + token);
            }
            try {
                BigDecimal num1 = this.parseNumber(parts[0]);
                this.testNumber(num1);
                BigDecimal num2 = this.parseNumber(parts[1]);
                this.testNumber(num2);
                this.testRange(num1, num2);
            }
            catch (NumberFormatException e) {
                throw new LimitingDocument.Rejection("Not a valid range in token: " + token);
            }
        }
        try {
            this.testNumber(this.parseNumber(token));
        }
        catch (NumberFormatException e) {
            throw new LimitingDocument.Rejection("Invalid number in token: " + token);
        }
    }

    protected BigDecimal parseNumber(String string) {
        return new BigDecimal(string);
    }

    protected abstract void testNumber(BigDecimal var1) throws LimitingDocument.Rejection;

    protected abstract void testRange(BigDecimal var1, BigDecimal var2) throws LimitingDocument.Rejection;
}

