/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.validation;

import java.util.Enumeration;
import java.util.regex.Pattern;

public class XffHeaderValidator {
    private static final Pattern SimpleIpAddress = Pattern.compile("[0-9a-f.:, /]+");
    private static final int maxAllowedIPAddressLength = 256;

    public String createModifiedXffString(Enumeration<String> xffHeaders) {
        if (xffHeaders == null) {
            return null;
        }
        StringBuilder xffAddresses = new StringBuilder();
        String delimiter = "";
        while (xffHeaders.hasMoreElements()) {
            String address = xffHeaders.nextElement();
            xffAddresses.append(delimiter).append(address);
            delimiter = ", ";
        }
        int length = xffAddresses.length();
        if (length > 256) {
            int firstPossibleIndex = length - 256;
            int actualFirstIndex = xffAddresses.indexOf(",", firstPossibleIndex);
            if (actualFirstIndex != -1) {
                return xffAddresses.substring(actualFirstIndex).trim();
            }
            return null;
        }
        return xffAddresses.toString().trim();
    }

    public boolean isIpAddresses(String addresses) {
        return SimpleIpAddress.matcher(addresses.toLowerCase()).matches();
    }

    public int getMaxAllowedIPAddressLength() {
        return 256;
    }
}

