/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.csv;

import com.ericsson.utils.csv.CSVCodecException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class CSVFieldOrder {
    private final List<Field> listOfFieldsInOrder;

    public static <T> CSVFieldOrder create(Class<T> cls, String[] fieldOrderAsString) throws CSVCodecException {
        LinkedList<Field> tmp = new LinkedList<Field>();
        boolean found = false;
        Set<Field> fields = CSVFieldOrder.getAllDeclaredFields(cls, new HashSet<Field>());
        for (String fieldName : fieldOrderAsString) {
            found = false;
            for (Field field : fields) {
                if (!fieldName.equals(field.getName())) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new CSVCodecException(String.format("Field : %s is declared static in class %s", fieldName, cls.getSimpleName()));
                }
                tmp.add(field);
                found = true;
                break;
            }
            if (found) continue;
            throw new CSVCodecException(String.format("Field : %s not a member of class %s", fieldName, cls.getSimpleName()));
        }
        return new CSVFieldOrder(tmp);
    }

    private static Set<Field> getAllDeclaredFields(Class<?> cls, Set<Field> result) {
        if (cls == Object.class) {
            return result;
        }
        result.addAll(Arrays.asList(cls.getDeclaredFields()));
        return CSVFieldOrder.getAllDeclaredFields(cls.getSuperclass(), result);
    }

    private CSVFieldOrder(List<Field> listOfFieldsInOrder) {
        this.listOfFieldsInOrder = Collections.unmodifiableList(listOfFieldsInOrder);
    }

    public List<Field> get() {
        return this.listOfFieldsInOrder;
    }
}

