/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtilities {
    public static boolean match(String list1, String list2) {
        String[] list1Split = list1.trim().split(",");
        String[] list2Split = list2.trim().split(",");
        for (int i = 0; i < list1Split.length; ++i) {
            if (list1Split[i].trim().equals("*")) {
                return true;
            }
            for (int j = 0; j < list2Split.length; ++j) {
                if (!list2Split[j].trim().equals("*") && !list1Split[i].trim().equals(list2Split[j].trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static String expandString(String string, Properties values) {
        return StringUtilities.expandString(string, new HashMap<Object, Object>(values));
    }

    public static String expandString(String string, Map<String, String> values) {
        Matcher m;
        if (string == null) {
            return string;
        }
        StringBuffer result = new StringBuffer(string);
        Pattern p = Pattern.compile("\\$\\{(.+?)\\}");
        while ((m = p.matcher("" + result.toString())).find()) {
            if (values.get(m.group(1)) != null) {
                result.replace(m.start(), m.end(), values.get(m.group(1)));
                continue;
            }
            throw new IllegalArgumentException("Missing value of variable " + m.group(1));
        }
        return result.toString();
    }

    public static String expandString(String string, String key, String value) {
        StringBuffer result = new StringBuffer(string);
        key = "${" + key + "}";
        int start = string.indexOf(key);
        while (start != -1) {
            result.replace(start, start + key.length(), value);
            start = result.indexOf(key, start + value.length());
        }
        return result.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isBlank(String str) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String join(List<String> items, String conjunction) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String item : items) {
            if (!first) {
                builder.append(conjunction);
            }
            builder.append(item);
            first = false;
        }
        return builder.toString();
    }
}

