/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.functional.typed;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;

@FunctionalInterface
public interface CheckedRunnable<E extends Exception> {
    public void apply() throws E;

    public static Runnable toUnchecked(CheckedRunnable<Exception> runnable) {
        Preconditions.checkNotNull(runnable);
        return () -> {
            try {
                runnable.apply();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

