/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.functional.typed;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;

@FunctionalInterface
public interface CheckedFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    public static <T, R> Function<T, R> toUnchecked(CheckedFunction<T, R, Exception> function) {
        Preconditions.checkNotNull(function);
        return t -> {
            try {
                return function.apply(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

