/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.functional;

import java.io.IOException;
import java.io.UncheckedIOException;

@FunctionalInterface
public interface UncheckedCloseable
extends Runnable,
AutoCloseable {
    @Override
    default public void run() {
        try {
            this.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static UncheckedCloseable wrap(AutoCloseable closable) {
        return closable::close;
    }

    default public UncheckedCloseable nest(AutoCloseable closable) {
        return () -> {
            try {
                closable.close();
            }
            catch (Exception outer) {
                try {
                    this.close();
                }
                catch (Exception inner) {
                    outer.addSuppressed(inner);
                }
                throw outer;
            }
            this.close();
        };
    }
}

