/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.console;

import com.ericsson.lwac.statistics.StatisticsName;
import com.ericsson.lwac.utilities.console.Column;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class Row {
    private final Map<Column, String> values;
    private final List<Row> children;

    private Row(Builder builder) {
        this.values = builder.columns.build();
        this.children = builder.subRows.build();
    }

    public int getWidth(Column column) {
        return this.getWidth(0, 0, column);
    }

    public int getWidth(int offset, int indent, Column column) {
        String value = Objects.requireNonNull(this.values).getOrDefault(column, "");
        int thisLength = value.length() + offset;
        Optional<Integer> maxChildrenWidth = this.children.stream().map(row -> row.getWidth(offset + indent, indent, column)).max(Integer::compare);
        return maxChildrenWidth.map(integer -> Math.max(thisLength, integer)).orElse(thisLength);
    }

    public String getValue(Column column) {
        String value = this.values.get(column);
        if (value == null) {
            return "-";
        }
        return value;
    }

    public Optional<String> tryGetValue(Column column) {
        return Optional.ofNullable(this.values.get(column));
    }

    public Map<Column, String> getValues() {
        return this.values;
    }

    public List<Row> getChildren() {
        return this.children;
    }

    public boolean hasValue(Column column) {
        return this.values.containsKey(column);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<Column, String> columns = ImmutableMap.builder();
        private final ImmutableList.Builder<Row> subRows = ImmutableList.builder();

        public Builder column(StatisticsName name, String value) {
            if (value != null) {
                this.columns.put(new Column(name), value);
            }
            return this;
        }

        void add(Row row) {
            this.subRows.add((Object)row);
        }

        public Row build() {
            return new Row(this);
        }
    }
}

