/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.console;

import com.ericsson.lwac.utilities.console.Row;
import com.ericsson.lwac.utilities.console.SortInfo;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DefaultRowComparator
implements Comparator<Row> {
    private static final Pattern PATTERN_NUMERIC = Pattern.compile("([-+]?\\d+(?:\\.\\d+)?).*");
    private final SortInfo sortInfo;

    public DefaultRowComparator(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Override
    public int compare(Row left, Row right) {
        if (SortInfo.SortDirection.ASCENDING == this.sortInfo.getSortDirection()) {
            return this.ascendingOrder(this.getValue(left), this.getValue(right));
        }
        if (SortInfo.SortDirection.DESCENDING == this.sortInfo.getSortDirection()) {
            return this.descendingOrder(this.getValue(left), this.getValue(right));
        }
        return 0;
    }

    private Value getValue(Row row) {
        String value = row.tryGetValue(this.sortInfo.getColumn()).orElse(null);
        if (value == null) {
            return null;
        }
        Matcher matcher = PATTERN_NUMERIC.matcher(value);
        if (matcher.matches()) {
            String numericValue = matcher.group(1);
            return new Value(new BigDecimal(numericValue), value);
        }
        return new Value(value);
    }

    private int descendingOrder(Value left, Value right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        return left.compareTo(right) * -1;
    }

    private int ascendingOrder(Value left, Value right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return 1;
        }
        if (right == null) {
            return -1;
        }
        return left.compareTo(right);
    }

    private static final class Value
    implements Comparable<Value> {
        private final String originalValue;
        private final BigDecimal numericValue;

        public Value(String originalValue) {
            this.originalValue = originalValue;
            this.numericValue = null;
        }

        public Value(BigDecimal numericValue, String originalValue) {
            this.numericValue = numericValue;
            this.originalValue = originalValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.numericValue == null ? 0 : this.numericValue.hashCode());
            result = 31 * result + (this.originalValue == null ? 0 : this.originalValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            if (this.numericValue == null ? other.numericValue != null : !this.numericValue.equals(other.numericValue)) {
                return false;
            }
            return !(this.originalValue == null ? other.originalValue != null : !this.originalValue.equals(other.originalValue));
        }

        @Override
        public int compareTo(Value other) {
            if (this.numericValue != null && other.numericValue != null) {
                return this.numericValue.compareTo(other.numericValue);
            }
            return this.originalValue.compareTo(other.originalValue);
        }
    }
}

