/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.console;

import com.ericsson.lwac.statistics.StatisticsName;
import com.ericsson.lwac.utilities.console.TreeTable;
import com.google.common.base.CaseFormat;

final class Column {
    private final StatisticsName name;
    private final TreeTable.ColumnAlignment alignment;

    public Column(StatisticsName name) {
        this.name = name;
        this.alignment = TreeTable.ColumnAlignment.LEFT;
    }

    public Column(StatisticsName name, TreeTable.ColumnAlignment alignment) {
        this.name = name;
        this.alignment = alignment;
    }

    public StatisticsName getName() {
        return this.name;
    }

    public String getDisplayName() {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.name.getValueAsString()).toUpperCase();
    }

    public int getWidth() {
        return this.getDisplayName().length();
    }

    public TreeTable.ColumnAlignment getAlignment() {
        return this.alignment;
    }

    public String toString() {
        return String.valueOf(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

