/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.ericsson.lwac.transaction.Transaction;
import com.ericsson.lwac.transaction.TransactionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class TransactionCache<K, V> {
    private final Map<Transaction, Map<K, V>> cache = new ConcurrentHashMap<Transaction, Map<K, V>>();
    private TransactionManager transactionManager;

    public TransactionCache() {
        try {
            InitialContext context = new InitialContext();
            this.transactionManager = (TransactionManager)context.lookup("java:/TransactionManager");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public V get(K key) {
        Map<K, V> transactionCache;
        V result = null;
        if (this.transactionManager.getTransaction().isPresent() && (transactionCache = this.cache.get(this.transactionManager.getTransaction().get())) != null) {
            result = transactionCache.get(key);
        }
        return result;
    }

    public V remove(K key) {
        Map<K, V> transactionCache;
        V result = null;
        if (this.transactionManager.getTransaction().isPresent() && (transactionCache = this.cache.get(this.transactionManager.getTransaction().get())) != null) {
            result = transactionCache.remove(key);
        }
        return result;
    }

    public void put(K key, V value) {
        if (this.transactionManager.getTransaction().isPresent()) {
            Transaction transaction = this.transactionManager.getTransaction().get();
            Map<K, V> transactionCache = this.cache.get(transaction);
            if (transactionCache == null) {
                transactionCache = new HashMap();
                this.cache.put(transaction, transactionCache);
                this.transactionManager.afterCompletion(this.cache::remove);
            }
            transactionCache.put(key, value);
        }
    }
}

