/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.statistics;

import com.ericsson.lwac.statistics.StatisticsName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class StatisticsDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<StatisticsName> statisticsNames;

    protected StatisticsDefinition(Builder builder) {
        this.statisticsNames = Collections.unmodifiableList(builder.statisticsNames);
    }

    public List<StatisticsName> getStatisticsNames() {
        return this.statisticsNames;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<StatisticsName> statisticsNames = new ArrayList<StatisticsName>();

        public Builder name(StatisticsName statisticsName) {
            this.statisticsNames.add(statisticsName);
            return this;
        }

        public Builder name(String name) {
            this.statisticsNames.add(StatisticsName.fromString(name));
            return this;
        }

        public Builder names(Iterable<StatisticsName> names) {
            if (names != null) {
                names.forEach(this.statisticsNames::add);
            }
            return this;
        }

        public StatisticsDefinition build() {
            return new StatisticsDefinition(this);
        }
    }
}

