/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.settings;

import com.ericsson.lwac.deployer.ServiceName;
import com.ericsson.lwac.settings.Property;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public final class ServiceSettings {
    private final String beanClass;
    private final List<Property> properties;
    private final ServiceName name;
    private final boolean replaceable;
    private final Element configurationElement;

    private ServiceSettings(Builder builder) {
        this.name = builder.name;
        this.beanClass = builder.beanClass;
        this.replaceable = builder.replaceable;
        this.properties = Collections.unmodifiableList(builder.properties);
        this.configurationElement = builder.configurationElement == null ? null : (Element)builder.configurationElement.cloneNode(true);
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public ServiceName getName() {
        return this.name;
    }

    public Element getConfigurationElement() {
        return this.configurationElement == null ? null : (Element)this.configurationElement.cloneNode(true);
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public String toString() {
        return "ServiceSettings [name=" + String.valueOf(this.name) + ", beanClass=" + this.beanClass + "]";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ServiceName name;
        private String beanClass;
        private List<Property> properties = new LinkedList<Property>();
        private boolean replaceable;
        private Element configurationElement;

        private Builder() {
        }

        public Builder name(ServiceName name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = ServiceName.valueOf(name);
            return this;
        }

        public Builder beanClass(String beanClass) {
            this.beanClass = beanClass;
            return this;
        }

        public Builder properties(List<Property> properties) {
            this.properties = properties;
            return this;
        }

        public Builder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }

        public Builder replaceable(boolean replaceable) {
            this.replaceable = replaceable;
            return this;
        }

        public Builder configurationElement(Element configurationElement) {
            this.configurationElement = configurationElement;
            return this;
        }

        public ServiceSettings build() {
            return new ServiceSettings(this);
        }
    }
}

