/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.session;

import com.ericsson.lwac.actions.Action;
import com.ericsson.lwac.deployer.ObjectName;
import com.ericsson.lwac.security.authentication.AuthenticationErrorException;
import com.ericsson.lwac.security.authentication.AuthenticationFailedException;
import com.ericsson.lwac.security.authentication.ChangeCredentialException;
import com.ericsson.lwac.security.authentication.InvalidCredentialException;
import com.ericsson.lwac.security.authentication.Secret;
import com.ericsson.lwac.security.authentication.SessionLimitExceededException;
import com.ericsson.lwac.security.authorization.AuthorizationErrorException;
import com.ericsson.lwac.security.authorization.AuthorizationFailedException;
import com.ericsson.lwac.security.authorization.AuthorizationProvider;
import com.ericsson.lwac.security.session.AuthenticationResult;
import com.ericsson.lwac.security.session.Session;
import com.ericsson.lwac.security.session.SessionHeaders;
import com.ericsson.lwac.security.session.SessionIdGenerator;
import com.ericsson.lwac.security.session.SessionLogEventListener;
import java.util.List;
import java.util.Optional;

public interface SessionManager {
    public AuthenticationResult loginPrimary(ObjectName var1, String var2, String var3, Secret var4, boolean var5, SessionHeaders var6, SessionData ... var7) throws AuthenticationFailedException, SessionLimitExceededException, AuthenticationErrorException;

    public AuthenticationResult loginSecondary(ObjectName var1, String var2, String var3, Secret var4, SessionHeaders var5) throws AuthenticationFailedException, SessionLimitExceededException, AuthenticationErrorException;

    default public AuthenticationResult loginSecondary(ObjectName objectName, String protocol, String sessionToken, Secret secret, String authType, SessionHeaders headers) throws AuthenticationFailedException, SessionLimitExceededException, AuthenticationErrorException {
        throw new UnsupportedOperationException("TOTP authentication not supported.");
    }

    public AuthenticationResult changeCredential(ObjectName var1, String var2, String var3, String var4, Secret var5, Secret var6, Secret var7, SessionHeaders var8) throws ChangeCredentialException, AuthenticationErrorException, SessionLimitExceededException, AuthenticationFailedException, InvalidCredentialException;

    public Session loginInternally(String var1);

    public Session loginWithOutPermissions(String var1, String var2, SessionHeaders var3) throws AuthenticationErrorException;

    public Session resumeSession(String var1, String var2) throws AuthenticationErrorException;

    public Session resumeUnauthenticatedSession(String var1, String var2) throws AuthenticationErrorException;

    public void logout(String var1, String var2);

    public void logoutInternal(String var1);

    public void reset();

    public void resumeInternalSession(Session var1);

    public void registerSessionLogEventListener(SessionLogEventListener var1);

    public void timeoutAllSessions();

    public Optional<Long> getSessionIdFromToken(String var1);

    public List<Long> getSessionIdsFromUniqueId(String var1);

    public void setEffectiveUser(String var1) throws AuthorizationFailedException, AuthorizationErrorException;

    public void setEffectiveUserWithPermissions(String var1, String ... var2) throws AuthorizationFailedException, AuthorizationErrorException;

    public <T, E extends Throwable> T invokeAsEffectiveUser(String var1, Action<T, E> var2) throws E, AuthorizationErrorException, AuthorizationFailedException;

    public <T, E extends Throwable> T invokeAsEffectiveUserWithPermissions(String var1, Action<T, E> var2, String ... var3) throws E, AuthorizationErrorException, AuthorizationFailedException;

    public <T, E extends Throwable> T invokeAsRealUserAndEffectiveUser(String var1, String var2, Action<T, E> var3) throws E, AuthorizationErrorException, AuthorizationFailedException;

    public void registerAuthorizationProvider(String var1, AuthorizationProvider var2);

    public Session loginInternally(String var1, String var2);

    public void registerSessionIdGenerator(SessionIdGenerator var1);

    public boolean revokeSession(long var1);

    public List<String> listSessions(String var1);

    public boolean isTotpSetupActive(String var1);

    public static class SessionData {
        private final String key;
        private final Object value;
        private final boolean distributed;

        public SessionData(String key, Object value, boolean distributed) {
            this.key = key;
            this.value = value;
            this.distributed = distributed;
        }

        String getKey() {
            return this.key;
        }

        Object getValue() {
            return this.value;
        }

        boolean isDistributed() {
            return this.distributed;
        }
    }
}

