/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.authorization;

import com.ericsson.lwac.security.authorization.UnsupportedGrantTypeException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlEnum
@XmlType(namespace="http://www.ericsson.com/lwac/security/authorization/common", name="granttype")
public enum GrantType {
    PASSWORD("password"),
    REFRESH_TOKEN("refresh_token"),
    JWT_BEARER("urn:ietf:params:oauth:grant-type:jwt-bearer"),
    TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange");

    private static final Map<String, GrantType> grantTypes;
    private final String name;

    private GrantType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static GrantType fromString(String text) {
        GrantType grantType = grantTypes.get(text);
        if (grantType == null) {
            throw new UnsupportedGrantTypeException("unsupported_grant_type");
        }
        return grantType;
    }

    static {
        grantTypes = new HashMap<String, GrantType>();
        for (GrantType grantType : GrantType.values()) {
            grantTypes.put(grantType.toString(), grantType);
        }
    }
}

