/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.net.ws.core;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class WebSocketPingPongPolicy {
    public static final WebSocketPingPongPolicy DEFAULT_SEND_PINGS = WebSocketPingPongPolicy.newBuilder().sendPings(Duration.ofSeconds(10L), Duration.ofSeconds(5L)).build();
    public static final WebSocketPingPongPolicy ONLY_RESPOND = WebSocketPingPongPolicy.newBuilder().build();
    private final Duration pingInterval;
    private final Duration pongTimeout;

    private WebSocketPingPongPolicy(Builder builder) {
        this.pingInterval = builder.pingInterval;
        this.pongTimeout = builder.pongTimeout;
    }

    public Optional<Duration> getPingInterval() {
        return Optional.ofNullable(this.pingInterval);
    }

    public Optional<Duration> getPongTimeout() {
        return Optional.ofNullable(this.pongTimeout);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketPingPongPolicy that = (WebSocketPingPongPolicy)o;
        return Objects.equals(this.pingInterval, that.pingInterval) && Objects.equals(this.pongTimeout, that.pongTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.pingInterval, this.pongTimeout);
    }

    public static class Builder {
        private Duration pingInterval;
        private Duration pongTimeout;

        private Builder() {
        }

        public Builder sendPings(Duration pingInterval, Duration pongTimeout) {
            Preconditions.checkNotNull(pingInterval, "'pingInterval' is invalid, can not be null");
            Preconditions.checkNotNull(pongTimeout, "'pongTimeout' is invalid, can not be null");
            Preconditions.checkArgument(!pingInterval.isNegative(), "'pingInterval' is invalid, can not be negative");
            Preconditions.checkArgument(!pongTimeout.isNegative(), "'pongTimeout' is invalid, can not be negative");
            Preconditions.checkArgument(!pingInterval.isZero(), "'pingInterval' is invalid, can not be zero");
            Preconditions.checkArgument(!pongTimeout.isZero(), "'pongTimeout' is invalid, can not be zero");
            Preconditions.checkArgument(pingInterval.compareTo(pongTimeout) >= 0, "'pongTimeout' is invalid, can not be greater than 'pingInterval'");
            this.pingInterval = pingInterval;
            this.pongTimeout = pongTimeout;
            return this;
        }

        public WebSocketPingPongPolicy build() {
            return new WebSocketPingPongPolicy(this);
        }
    }
}

